/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModCommands;
import de.teamlapen.werewolves.core.ModContainer;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModEntityActions;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModLootTables;
import de.teamlapen.werewolves.core.ModMinionTasks;
import de.teamlapen.werewolves.core.ModOils;
import de.teamlapen.werewolves.core.ModRefinementSets;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModRegistries;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.core.ModTasks;
import de.teamlapen.werewolves.core.ModTiles;
import de.teamlapen.werewolves.core.ModVillage;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.world.WerewolvesBiomeFeatures;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class RegistryManager
implements IInitListener {
    public RegistryManager() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register(ModContainer.class);
        bus.addListener(ModEntities::onRegisterEntityTypeAttributes);
        bus.addListener(ModEntities::onModifyEntityTypeAttributes);
    }

    @SubscribeEvent
    public void onBuildRegistries(RegistryEvent.NewRegistry event) {
        ModRegistries.init();
    }

    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        switch (step) {
            case COMMON_SETUP: {
                event.enqueueWork(ModBiomes::addBiomesToGeneratorUnsafe);
                ModEntities.registerSpawns();
                event.enqueueWork(ModCommands::registerArgumentTypesUsages);
                WerewolvesBiomeFeatures.init();
                ModBiomes.removeStructuresFromBiomes();
                event.enqueueWork(ModVillage::villageTradeSetup);
                event.enqueueWork(ModEntities::initializeEntities);
                event.enqueueWork(WerewolvesBiomeFeatures::registerBiomeFeatures);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onMissingItem(RegistryEvent.MissingMappings<Item> event) {
        ModItems.remapItems(event);
    }

    public static void setupRegistries(IEventBus bus) {
        ModActions.registerActions(bus);
        ModAttributes.registerAttributes(bus);
        ModBiomes.registerBiomes(bus);
        ModBlocks.registerBlocks(bus);
        ModContainer.registerContainers(bus);
        ModEffects.registerEffects(bus);
        ModEntities.registerEntities(bus);
        ModEntityActions.registerEntityActions(bus);
        ModItems.registerItems(bus);
        ModMinionTasks.registerMinionTasks(bus);
        ModOils.registerOils(bus);
        ModRefinements.registerRefinements(bus);
        ModRefinementSets.registerRefinementSets(bus);
        ModTasks.registerTasks(bus);
        ModVillage.registerVillageObjects(bus);
        WerewolfSkills.registerSkills(bus);
        ModTiles.registerTiles(bus);
        ModLootTables.registerLootModifier(bus);
        ModSounds.registerSounds(bus);
    }
}

