/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "werewolves", existingFileHelper);
    }

    protected void registerModels() {
        HashSet<Block> blockParent = new HashSet<Block>(){
            {
                this.add(ModBlocks.SILVER_ORE.get());
                this.add(ModBlocks.SILVER_BLOCK.get());
                this.add(ModBlocks.JACARANDA_LEAVES.get());
                this.add(ModBlocks.JACARANDA_LOG.get());
                this.add(ModBlocks.MAGIC_LEAVES.get());
                this.add(ModBlocks.MAGIC_LOG.get());
                this.add(ModBlocks.MAGIC_PLANKS.get());
                this.add(ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF.get());
                this.add(ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF_CRAFTED.get());
            }
        };
        HashSet<Item> itemsLayer = new HashSet<Item>(){
            {
                this.add(ModItems.SILVER_INGOT.get());
                this.add(ModItems.LIVER.get());
                this.add(ModItems.CRACKED_BONE.get());
                this.add(ModItems.INJECTION_UN_WEREWOLF.get());
                this.add(ModItems.WEREWOLF_TOOTH.get());
                this.add(ModItems.WEREWOLF_MINION_CHARM.get());
                this.add(ModItems.WEREWOLF_MINION_UPGRADE_SIMPLE.get());
                this.add(ModItems.WEREWOLF_MINION_UPGRADE_ENHANCED.get());
                this.add(ModItems.WEREWOLF_MINION_UPGRADE_SPECIAL.get());
                this.add(ModItems.SILVER_NUGGET.get());
            }
        };
        HashSet<Block> blockLayer = new HashSet<Block>(){
            {
                this.add(ModBlocks.JACARANDA_SAPLING.get());
                this.add(ModBlocks.MAGIC_SAPLING.get());
                this.add(ModBlocks.WOLFSBANE.get());
            }
        };
        HashSet<Item> itemsHandHeld = new HashSet<Item>(){
            {
                this.add(ModItems.SILVER_AXE.get());
                this.add(ModItems.SILVER_PICKAXE.get());
                this.add(ModItems.SILVER_SWORD.get());
                this.add(ModItems.SILVER_SHOVEL.get());
                this.add(ModItems.SILVER_HOE.get());
            }
        };
        blockParent.forEach(this::block);
        itemsLayer.forEach(x$0 -> this.item((Item)x$0, new ResourceLocation[0]));
        blockLayer.forEach(x$0 -> this.blockLayer((Block)x$0, new ResourceLocation[0]));
        itemsHandHeld.forEach(item -> this.item((Item)item, "item/handheld", new ResourceLocation[0]));
        this.withExistingParent((Item)ModItems.WEREWOLF_BEAST_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.WEREWOLF_SURVIVALIST_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.HUMAN_WEREWOLF_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.withExistingParent((Item)ModItems.ALPHA_WEREWOLF_SPAWN_EGG.get(), this.mcLoc("item/template_spawn_egg"));
        this.item((Item)ModItems.DREAM_CATCHER.get(), this.modLoc("item/dream_catcher_layer0"), this.modLoc("item/dream_catcher_layer1"));
        this.item((Item)ModItems.CHARM_BRACELET.get(), this.modLoc("item/charm_bracelet_layer0"), this.modLoc("item/charm_bracelet_layer1"));
        this.item((Item)ModItems.BONE_NECKLACE.get(), this.modLoc("item/bone_necklace_layer0"), this.modLoc("item/bone_necklace_layer1"));
    }

    @Nonnull
    public String func_200397_b() {
        return "Werewolves item model generator";
    }

    public ItemModelBuilder item(String item, ResourceLocation ... texture) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated"));
        for (int i = 0; i < texture.length; ++i) {
            model.texture("layer" + i, texture[i]);
        }
        return model;
    }

    public ItemModelBuilder item(Item item, ResourceLocation ... texture) {
        return this.item(item, "item/generated", texture);
    }

    public ItemModelBuilder item(Item item, String parent, ResourceLocation ... texture) {
        if (texture.length == 0) {
            return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc(parent)).texture("layer0", "werewolves:item/" + item.getRegistryName().func_110623_a());
        }
        return this.item(item.getRegistryName().func_110623_a(), texture);
    }

    public ItemModelBuilder blockLayer(Block item, ResourceLocation ... texture) {
        if (texture.length == 0) {
            return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated")).texture("layer0", "werewolves:block/" + item.getRegistryName().func_110623_a());
        }
        return this.item(item.getRegistryName().func_110623_a(), texture);
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Item name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(name.getRegistryName().func_110623_a(), parent);
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Item name, Item parent) {
        return this.withExistingParent(name, parent.getRegistryName());
    }

    @Nonnull
    public ItemModelBuilder withExistingParent(Block name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(name.getRegistryName().func_110623_a(), parent);
    }

    public ItemModelBuilder block(Block name) {
        try {
            return (ItemModelBuilder)super.withExistingParent(name.getRegistryName().func_110623_a(), "werewolves:block/" + name.getRegistryName().func_110623_a());
        }
        catch (IllegalStateException e) {
            return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("werewolves:block/" + name.getRegistryName().func_110623_a()));
        }
    }
}

