/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.data;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import de.teamlapen.vampirism.world.loot.AddBookNbt;
import de.teamlapen.vampirism.world.loot.RefinementSetFunction;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModLootTables;
import de.teamlapen.werewolves.util.WReference;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.KilledByPlayer;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.conditions.RandomChanceWithLooting;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class LootTablesGenerator
extends LootTableProvider {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public LootTablesGenerator(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new ModBlockLootTables(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new ModEntityLootTables(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new InjectLootTables(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new ChestLootTables(), (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationTracker validationtracker) {
        map.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
    }

    private static class ChestLootTables
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private ChestLootTables() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            LootPool.Builder accessories = LootPool.func_216096_a().name("accessories").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.BONE_NECKLACE.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.CHARM_BRACELET.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.DREAM_CATCHER.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION)));
            consumer.accept(ModLootTables.abandoned_mineshaft, LootTable.func_216119_b().func_216040_a(accessories).func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.CRACKED_BONE.get())).func_216086_a(5)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(10))));
            consumer.accept(ModLootTables.desert_pyramid, LootTable.func_216119_b().func_216040_a(accessories).func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.LIVER.get())).func_216086_a(5)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(10))));
            consumer.accept(ModLootTables.jungle_temple, LootTable.func_216119_b().func_216040_a(accessories).func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.CRACKED_BONE.get())).func_216086_a(5)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(10))));
            consumer.accept(ModLootTables.stronghold_corridor, LootTable.func_216119_b().func_216040_a(accessories).func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.WEREWOLF_TOOTH.get())).func_216086_a(5)).func_216045_a((LootEntry.Builder)EmptyLootEntry.func_216167_a().func_216086_a(10))));
            consumer.accept(ModLootTables.stronghold_library, LootTable.func_216119_b().func_216040_a(accessories));
        }
    }

    private static class InjectLootTables
    implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
        private InjectLootTables() {
        }

        @Override
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(ModLootTables.villager, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("liver").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.LIVER.get())).func_216086_a(1).func_212840_b_(RandomChance.func_216004_a((float)0.5f)))));
            consumer.accept(ModLootTables.skeleton, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("bones").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.CRACKED_BONE.get())).func_216086_a(1).func_212840_b_(RandomChance.func_216004_a((float)0.1f)))));
        }
    }

    private static class ModEntityLootTables
    extends EntityLootTables {
        private ModEntityLootTables() {
        }

        protected void addTables() {
            this.func_218582_a((EntityType)ModEntities.TASK_MASTER_WEREWOLF.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.WEREWOLF_MINION.get(), LootTable.func_216119_b());
            LootTable.Builder werewolf = LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.33f, (float)0.05f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.LIVER.get())))).func_216040_a(LootPool.func_216096_a().name("general2").func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.33f, (float)0.05f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.CRACKED_BONE.get())).func_216086_a(40))).func_216040_a(LootPool.func_216096_a().name("accessories").func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChance.func_216004_a((float)0.05f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.BONE_NECKLACE.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.CHARM_BRACELET.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.DREAM_CATCHER.get())).func_216086_a(1).func_212841_b_((ILootFunction.IBuilder)RefinementSetFunction.builder(WReference.WEREWOLF_FACTION))));
            this.func_218582_a((EntityType)ModEntities.WEREWOLF_SURVIVALIST.get(), werewolf);
            this.func_218582_a((EntityType)ModEntities.WEREWOLF_BEAST.get(), werewolf);
            this.func_218582_a((EntityType)ModEntities.HUMAN_WEREWOLF.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.33f, (float)0.05f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.LIVER.get())))).func_216040_a(LootPool.func_216096_a().name("general2").func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.33f, (float)0.05f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.CRACKED_BONE.get())).func_216086_a(6))).func_216040_a(LootPool.func_216096_a().name("hunter").func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.1f, (float)0.1f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.V.VAMPIRE_BOOK.get())).func_212841_b_((ILootFunction.IBuilder)AddBookNbt.builder()).func_216086_a(1))));
            this.func_218582_a((EntityType)ModEntities.WOLF.get(), LootTable.func_216119_b());
            this.func_218582_a((EntityType)ModEntities.ALPHA_WEREWOLF.get(), LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("general").func_212840_b_(KilledByPlayer.func_215994_b()).func_216046_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.WEREWOLF_TOOTH.get())))).func_216040_a(LootPool.func_216096_a().name("vampire_book").func_212840_b_(KilledByPlayer.func_215994_b()).func_212840_b_(RandomChanceWithLooting.func_216003_a((float)0.1f, (float)0.1f)).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.V.VAMPIRE_BOOK.get())).func_212841_b_((ILootFunction.IBuilder)AddBookNbt.builder()).func_216086_a(1))));
        }

        @Nonnull
        protected Iterable<EntityType<?>> getKnownEntities() {
            return ModEntities.getAllEntities();
        }
    }

    private static class ModBlockLootTables
    extends BlockLootTables {
        private ModBlockLootTables() {
        }

        protected void addTables() {
            this.func_218507_a((Block)ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF.get(), LootTable.func_216119_b());
            this.func_218507_a((Block)ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF_CRAFTED.get(), ModBlockLootTables.func_218546_a((IItemProvider)((IItemProvider)de.teamlapen.vampirism.core.ModBlocks.TOTEM_TOP.get())));
            this.func_218492_c((Block)ModBlocks.JACARANDA_SAPLING.get());
            this.func_218492_c((Block)ModBlocks.MAGIC_SAPLING.get());
            this.func_218492_c((Block)ModBlocks.WOLFSBANE.get());
            this.func_218492_c((Block)ModBlocks.SILVER_BLOCK.get());
            this.func_218492_c((Block)ModBlocks.SILVER_ORE.get());
            this.func_218547_a((Block)ModBlocks.POTTED_WOLFSBANE.get());
            this.func_218492_c((Block)ModBlocks.JACARANDA_LOG.get());
            this.func_218492_c((Block)ModBlocks.MAGIC_LOG.get());
            this.func_218492_c((Block)ModBlocks.STONE_ALTAR.get());
            this.func_218492_c((Block)ModBlocks.MAGIC_PLANKS.get());
            this.func_218522_a((Block)ModBlocks.JACARANDA_LEAVES.get(), block -> ModBlockLootTables.func_218540_a((Block)block, (Block)((Block)ModBlocks.JACARANDA_SAPLING.get()), (float[])DEFAULT_SAPLING_DROP_RATES));
            this.func_218522_a((Block)ModBlocks.MAGIC_LEAVES.get(), block -> ModBlockLootTables.func_218540_a((Block)block, (Block)((Block)ModBlocks.MAGIC_SAPLING.get()), (float[])DEFAULT_SAPLING_DROP_RATES));
            this.func_218492_c((Block)ModBlocks.STONE_ALTAR_FIRE_BOWL.get());
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return ModBlocks.BLOCKS.getEntries().stream().flatMap(RegistryObject::stream).collect(Collectors.toList());
        }
    }
}

