/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.tileentity.TotemHelper;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.effects.SilverEffect;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.network.AttackTargetEventPacket;
import de.teamlapen.werewolves.util.BiteDamageSource;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WReference;
import de.teamlapen.werewolves.util.WerewolfForm;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModEntityEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Predicate<LivingEntity> nonWerewolfCheck = entity -> !Helper.isWerewolf((Entity)entity);
    private static final Object2BooleanMap<String> entityAIReplacementWarnMap = new Object2BooleanArrayMap();
    private static final UUID ARMOR_REDUCTION = UUID.fromString("5b7612e9-1847-435c-b4eb-a455af4ce8c7");

    @SubscribeEvent
    public void onEntityAttacked(AttackEntityEvent event) {
        if (event.getTarget() instanceof LivingEntity && Helper.isWerewolf(event.getTarget()) && ModTags.Items.SILVER_TOOL.func_230235_a_((Object)event.getPlayer().func_184614_ca().func_77973_b())) {
            ((LivingEntity)event.getTarget()).func_195064_c(SilverEffect.createEffect((LivingEntity)event.getTarget(), (Integer)WerewolvesConfig.BALANCE.UTIL.silverItemEffectDuration.get()));
        }
        if (event.getTarget() instanceof WerewolfTransformable && ((WerewolfTransformable)event.getTarget()).canTransform()) {
            ((WerewolfTransformable)event.getTarget()).transformToWerewolf(WerewolfTransformable.TransformType.TIME_LIMITED);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        ModifiableAttributeInstance s = event.getEntityLiving().func_110148_a(Attributes.field_233826_i_);
        if (s != null) {
            s.func_188479_b(ARMOR_REDUCTION);
            if (event.getSource() instanceof EntityDamageSource && event.getSource().func_76346_g() != null && Helper.isWerewolf(event.getSource().func_76346_g())) {
                HashSet modifiers = new HashSet();
                int i = 0;
                for (ItemStack stack : event.getEntityLiving().func_184193_aE()) {
                    modifiers.addAll(stack.func_111283_C(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)i++)).get((Object)Attributes.field_233826_i_));
                }
                ModifiableAttributeInstance tmp = new ModifiableAttributeInstance(Attributes.field_233826_i_, a -> {});
                s.func_225505_c_().stream().filter(modifiers::contains).forEach(arg_0 -> ((ModifiableAttributeInstance)tmp).func_233767_b_(arg_0));
                double value = s.func_111126_e() - (s.func_111126_e() - tmp.func_111126_e());
                float levelModifier = WerewolfPlayer.getOptEx(event.getSource().func_76346_g()).map(player -> Float.valueOf((float)player.getLevel() / (float)player.getMaxLevel())).orElse(Float.valueOf(1.0f)).floatValue();
                s.func_233767_b_(new AttributeModifier(ARMOR_REDUCTION, "werewolf_attack", -value * ((event.getSource() instanceof BiteDamageSource ? 0.8 : 0.3) * (double)levelModifier), AttributeModifier.Operation.ADDITION));
            }
        }
        if (Helper.isWerewolf(event.getEntity()) && !event.getSource().func_82725_o()) {
            float damage = event.getAmount();
            float damageReduction = ((Float)FormHelper.getForm(event.getEntityLiving()).getDamageReduction().getLeft()).floatValue();
            damageReduction *= event.getEntityLiving() instanceof PlayerEntity ? WerewolfPlayer.getOpt((PlayerEntity)event.getEntityLiving()).filter(a -> !a.getForm().isHumanLike()).filter(a -> a.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.THICK_FUR.get())).map(a -> (Double)WerewolvesConfig.BALANCE.SKILLS.thick_fur_multiplier.get()).orElse(1.0).floatValue() : 1.0f;
            if (event.getSource().func_76346_g() != null && Helper.isVampire((Entity)event.getSource().func_76346_g())) {
                damageReduction = (float)((double)damageReduction * 0.3);
            }
            event.setAmount(MathHelper.func_76131_a((float)(damage -= event.getAmount() * damageReduction), (float)0.0f, (float)Float.MAX_VALUE));
        }
    }

    @SubscribeEvent
    public void onAttack(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof ServerPlayerEntity && Helper.isWerewolf((PlayerEntity)event.getTarget())) {
            WerewolfPlayer.getOpt((PlayerEntity)event.getTarget()).ifPresent(werewolf -> {
                if (werewolf.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.SIXTH_SENSE.get())) {
                    WerewolvesMod.dispatcher.sendTo((IMessage)new AttackTargetEventPacket(event.getEntity().func_145782_y()), (ServerPlayerEntity)event.getTarget());
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.func_201670_d()) {
            return;
        }
        if (event.getEntity() instanceof VillagerEntity) {
            TotemHelper.getTotemNearPos((ServerWorld)((ServerWorld)event.getWorld()), (BlockPos)event.getEntity().func_233580_cy_(), (boolean)true).ifPresent(totem -> {
                if (WReference.WEREWOLF_FACTION.equals((Object)totem.getControllingFaction()) && ((VillagerEntity)event.getEntity()).func_70681_au().nextInt(6) == 0) {
                    ((IVillagerTransformable)event.getEntity()).setWerewolfFaction(true);
                }
            });
        }
        if (((Boolean)WerewolvesConfig.BALANCE.UTIL.skeletonIgnoreWerewolves.get()).booleanValue() && (event.getEntity() instanceof SkeletonEntity || event.getEntity() instanceof StrayEntity)) {
            ModEntityEventHandler.makeWerewolfFriendly("skeleton", (AbstractSkeletonEntity)event.getEntity(), NearestAttackableTargetGoal.class, PlayerEntity.class, 2, (entity, predicate) -> new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 10, true, false, predicate), type -> type == EntityType.field_200741_ag || type == EntityType.field_200750_ap);
        }
    }

    public static <T extends MobEntity, S extends LivingEntity, Q extends NearestAttackableTargetGoal<S>> void makeWerewolfFriendly(String name, T entity, Class<Q> targetClass, Class<S> targetEntityClass, int attackPriority, BiFunction<T, Predicate<LivingEntity>, Q> replacement, Predicate<EntityType<? extends T>> typeCheck) {
        try {
            Goal target = null;
            for (PrioritizedGoal t : entity.field_70715_bh.field_220892_d) {
                Goal g = t.func_220772_j();
                if (!targetClass.equals(g.getClass()) || t.func_220770_h() != attackPriority || !targetEntityClass.equals(((NearestAttackableTargetGoal)g).field_75307_b)) continue;
                target = g;
                break;
            }
            if (target != null) {
                entity.field_70715_bh.func_85156_a(target);
                EntityType type = entity.func_200600_R();
                if (typeCheck.test(type)) {
                    Predicate<LivingEntity> newPredicate = nonWerewolfCheck;
                    if (((NearestAttackableTargetGoal)target).field_220779_d.field_221023_h != null) {
                        newPredicate = newPredicate.and(((NearestAttackableTargetGoal)target).field_220779_d.field_221023_h);
                    }
                    entity.field_70715_bh.func_75776_a(attackPriority, (Goal)replacement.apply(entity, newPredicate));
                }
            } else if (entityAIReplacementWarnMap.getOrDefault((Object)name, true)) {
                LOGGER.warn("Could not replace {} attack target task for {}", (Object)name, (Object)entity.func_200600_R().func_212546_e());
                entityAIReplacementWarnMap.put((Object)name, false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not replace " + name + " attack target task for " + entity.func_200600_R().func_212546_e(), (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        ModifiableAttributeInstance s = event.getEntityLiving().func_110148_a(Attributes.field_233826_i_);
        if (s != null) {
            s.func_188479_b(ARMOR_REDUCTION);
        }
        if (event.getSource() instanceof EntityDamageSource) {
            WerewolfPlayer.getOptEx(event.getSource().func_76346_g()).filter(w -> w.getForm() == WerewolfForm.BEAST).filter(w -> w.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.THROAT_SEEKER.get()) && !UtilLib.canReallySee((LivingEntity)event.getEntityLiving(), (LivingEntity)w.getRepresentingPlayer(), (boolean)true)).ifPresent(werewolf -> {
                if ((double)(event.getEntityLiving().func_110143_aJ() / event.getEntityLiving().func_110138_aP()) < 0.25 && werewolf.getRepresentingPlayer().func_70681_au().nextInt(4) < 1) {
                    event.setAmount(10000.0f);
                }
            });
        }
    }
}

