/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.werewolves.client.gui.WerewolfMinionAppearanceScreen;
import de.teamlapen.werewolves.client.gui.WerewolfMinionStatsScreen;
import de.teamlapen.werewolves.core.ModMinionTasks;
import de.teamlapen.werewolves.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.items.WerewolfMinionUpgradeItem;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WReference;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class WerewolfMinionEntity
extends MinionEntity<WerewolfMinionData>
implements IWerewolf {
    public static void registerMinionData() {
        MinionData.registerDataType((ResourceLocation)WerewolfMinionData.ID, () -> new WerewolfMinionData());
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        return BasicHunterEntity.getAttributeBuilder();
    }

    public WerewolfMinionEntity(EntityType<? extends VampirismEntity> type, World world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(WReference.WEREWOLF_FACTION, true, true, false, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof IMob && !(e instanceof CreeperEntity)));
    }

    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{(IMinionTask)ModMinionTasks.V.FOLLOW_LORD.get(), (IMinionTask)ModMinionTasks.V.DEFEND_AREA.get(), (IMinionTask)ModMinionTasks.V.STAY.get(), (IMinionTask)ModMinionTasks.V.PROTECT_LORD.get(), (IMinionTask)ModMinionTasks.COLLECT_WEREWOLF_ITEMS.get()});
    }

    public boolean shouldRenderLordSkin() {
        return false;
    }

    @Nonnull
    public IFaction<?> getFaction() {
        return WReference.WEREWOLF_FACTION;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().func_147108_a((Screen)new WerewolfMinionAppearanceScreen(this, Minecraft.func_71410_x().field_71462_r)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().func_147108_a((Screen)new WerewolfMinionStatsScreen(this, Minecraft.func_71410_x().field_71462_r)));
    }

    protected boolean canConsume(ItemStack stack) {
        if (!super.canConsume(stack)) {
            return false;
        }
        if (stack.func_222117_E() && !Helper.canWerewolfEatItem(stack)) {
            return false;
        }
        boolean fullHealth = this.func_110143_aJ() == this.func_110138_aP();
        return !fullHealth || !stack.func_222117_E();
    }

    @Nonnull
    public ItemStack func_213357_a(@Nonnull World world, @Nonnull ItemStack stack) {
        if (stack.func_222117_E() && Helper.isRawMeat(stack)) {
            float healAmount = (float)stack.func_77973_b().func_219967_s().func_221466_a() / 2.0f;
            this.func_70691_i(healAmount);
        }
        return super.func_213357_a(world, stack);
    }

    protected void onMinionDataReceived(@Nonnull WerewolfMinionData data) {
        super.onMinionDataReceived((MinionData)data);
        this.updateAttributes();
    }

    public Predicate<ItemStack> getEquipmentPredicate(EquipmentSlotType slotType) {
        return itemStack -> itemStack.func_77973_b() instanceof IFactionExclusiveItem && ((IFactionExclusiveItem)itemStack.func_77973_b()).getExclusiveFaction().equals(WReference.WEREWOLF_FACTION) || itemStack.func_77975_n() == UseAction.DRINK || itemStack.func_77975_n() == UseAction.EAT;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack heldItem;
        if (!this.field_70170_p.func_201670_d() && this.isLord(player) && this.minionData != null && (heldItem = player.func_184586_b(hand)).func_77973_b() instanceof WerewolfMinionUpgradeItem && ((WerewolfMinionUpgradeItem)heldItem.func_77973_b()).getFaction() == this.getFaction()) {
            if (((WerewolfMinionData)this.minionData).level + 1 >= ((WerewolfMinionUpgradeItem)heldItem.func_77973_b()).getMinLevel() && ((WerewolfMinionData)this.minionData).level + 1 <= ((WerewolfMinionUpgradeItem)heldItem.func_77973_b()).getMaxLevel()) {
                ((WerewolfMinionData)this.minionData).level++;
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.werewolf_minion.equipment_upgrade"), false);
                HelperLib.sync((Entity)this);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.werewolf_minion.equipment_wrong"), false);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.minionData != null ? ((WerewolfMinionData)this.minionData).form : WerewolfForm.NONE;
    }

    @Override
    public int getSkinType(@Nonnull WerewolfForm form) {
        return this.minionData != null ? ((WerewolfMinionData)this.minionData).skinType : 0;
    }

    @Override
    public int getEyeType(@Nonnull WerewolfForm form) {
        return this.minionData != null ? ((WerewolfMinionData)this.minionData).eyeType : 0;
    }

    @Override
    public boolean hasGlowingEyes(@Nonnull WerewolfForm form) {
        return this.minionData != null && ((WerewolfMinionData)this.minionData).glowingEyes;
    }

    private void updateAttributes() {
        ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(Attributes.field_233818_a_);
        BalanceMobProps.mobProps.getClass();
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance.func_111128_a(45.0 + 5.0 * (double)this.getMinionData().map(WerewolfMinionData::getHealthLevel).orElse(0).intValue());
        ModifiableAttributeInstance modifiableAttributeInstance2 = this.func_110148_a(Attributes.field_233823_f_);
        BalanceMobProps.mobProps.getClass();
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance2.func_111128_a(3.0 + 1.0 * (double)this.getMinionData().map(WerewolfMinionData::getStrengthLevel).orElse(0).intValue());
        ModifiableAttributeInstance modifiableAttributeInstance3 = this.func_110148_a(Attributes.field_233821_d_);
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance3.func_111128_a(0.28);
    }

    public void setEyeType(int type) {
        this.getMinionData().ifPresent(d -> ((WerewolfMinionData)d).eyeType = type);
    }

    public void setSkinType(int type) {
        this.getMinionData().ifPresent(d -> ((WerewolfMinionData)d).skinType = type);
    }

    public void setGlowingEyes(boolean glowing) {
        this.getMinionData().ifPresent(d -> ((WerewolfMinionData)d).glowingEyes = glowing);
    }

    public static class WerewolfMinionData
    extends MinionData {
        public static final ResourceLocation ID = new ResourceLocation("werewolves", "werewolf");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_RESOURCES = 2;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int resourceEfficiencyLevel;
        private int skinType;
        private int eyeType;
        private boolean glowingEyes;
        private WerewolfForm form = WerewolfForm.BEAST;

        public WerewolfMinionData(String name, int skinType, int eyeType, boolean glowingEyes, WerewolfForm form) {
            super(name, 9);
            assert (!form.isHumanLike());
            this.level = 0;
            this.skinType = skinType;
            this.eyeType = eyeType;
            this.glowingEyes = glowingEyes;
            this.form = form;
        }

        private WerewolfMinionData() {
        }

        public IFormattableTextComponent getFormattedName() {
            return super.getFormattedName().func_240699_a_(WReference.WEREWOLF_FACTION.getChatColor());
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        public int getLevel() {
            return this.level;
        }

        public int getSkinType() {
            return this.skinType;
        }

        public int getEyeType() {
            return this.eyeType;
        }

        public boolean hasGlowingEyes() {
            return this.glowingEyes;
        }

        public int getResourceEfficiencyLevel() {
            return this.resourceEfficiencyLevel;
        }

        public WerewolfForm getForm() {
            return this.form;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.strengthLevel - this.resourceEfficiencyLevel);
        }

        public boolean hasUsedSkillPoints() {
            return this.inventoryLevel + this.healthLevel + this.strengthLevel + this.resourceEfficiencyLevel > 0;
        }

        public void resetStats(MinionEntity<?> entity) {
            this.inventoryLevel = 0;
            this.strengthLevel = 0;
            this.healthLevel = 0;
            this.resourceEfficiencyLevel = 0;
            this.shrinkInventory(entity);
            super.resetStats(entity);
        }

        public int getInventorySize() {
            int size = this.getDefaultInventorySize();
            return this.inventoryLevel == 1 ? size + 3 : (this.inventoryLevel == 2 ? size + 6 : size);
        }

        public void handleMinionAppearanceConfig(String name, int ... data) {
            this.setName(name);
            this.skinType = data[0];
            this.eyeType = data[1];
            this.glowingEyes = data[2] == 1;
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        public boolean upgradeStat(int statId, MinionEntity<?> entity) {
            if (super.upgradeStat(statId, entity)) {
                return true;
            }
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof WerewolfMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((WerewolfMinionEntity)entity).updateAttributes();
                    entity.func_70606_j(entity.func_110138_aP());
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((WerewolfMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.resourceEfficiencyLevel >= 2) {
                        return false;
                    }
                    ++this.resourceEfficiencyLevel;
                    ((WerewolfMinionEntity)entity).updateAttributes();
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            super.deserializeNBT(nbt);
            this.level = nbt.func_74762_e("level");
            this.inventoryLevel = nbt.func_74762_e("l_inv");
            this.healthLevel = nbt.func_74762_e("l_he");
            this.strengthLevel = nbt.func_74762_e("l_str");
            this.resourceEfficiencyLevel = nbt.func_74762_e("l_res");
            this.skinType = nbt.func_74762_e("s_type");
            this.eyeType = nbt.func_74762_e("e_type");
            this.glowingEyes = nbt.func_74767_n("e_glow");
            this.form = WerewolfForm.getForm(nbt.func_74779_i("form"));
        }

        public void serializeNBT(CompoundNBT tag) {
            super.serializeNBT(tag);
            tag.func_74768_a("level", this.level);
            tag.func_74768_a("l_inv", this.inventoryLevel);
            tag.func_74768_a("l_he", this.healthLevel);
            tag.func_74768_a("l_str", this.strengthLevel);
            tag.func_74768_a("l_res", this.resourceEfficiencyLevel);
            tag.func_74768_a("s_type", this.skinType);
            tag.func_74768_a("e_type", this.eyeType);
            tag.func_74757_a("e_glow", this.glowingEyes);
            tag.func_74778_a("form", this.form.getName());
        }

        protected ResourceLocation getDataType() {
            return ID;
        }
    }
}

