/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.VampirismItemBloodFood;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.effects.UnWerewolfEffectInstance;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.mixin.LivingEntityInvoker;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WReference;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPlayerEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final UUID CLAWS = UUID.fromString("70435284-afcd-4470-85c2-d9b36b3d94e8");

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof PlayerEntity) {
            try {
                event.addCapability(REFERENCE.WEREWOLF_PLAYER_KEY, WerewolfPlayer.createNewCapability((PlayerEntity)event.getObject()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to attach capabilities to player. Player: {}", event.getObject());
                throw e;
            }
        }
    }

    @SubscribeEvent
    public void onFootEatenStart(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity()) && !Helper.canWerewolfPlayerEatItem((PlayerEntity)event.getEntity(), event.getItem())) {
            event.setCanceled(true);
            ((PlayerEntity)event.getEntity()).func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.no_meat"), true);
        }
    }

    @SubscribeEvent
    public void onFootEatenFinish(LivingEntityUseItemEvent.Finish event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity())) {
            if (Helper.isRawMeat(event.getItem())) {
                ((PlayerEntity)event.getEntityLiving()).func_71024_bL().func_221410_a(event.getItem().func_77973_b(), event.getItem());
            }
            if (event.getItem().func_77973_b() instanceof VampirismItemBloodFood) {
                event.getEntityLiving().func_195063_d(Effects.field_76431_k);
            }
        }
    }

    @SubscribeEvent
    public void onKilled(LivingDeathEvent event) {
        WerewolfPlayer player;
        if (event.getSource() instanceof EntityDamageSource && event.getSource().func_76346_g() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getSource().func_76346_g()) && (player = WerewolfPlayer.get((PlayerEntity)event.getSource().func_76346_g())).getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.HEALTH_AFTER_KILL.get())) {
            ((PlayerEntity)event.getSource().func_76346_g()).func_195064_c(new EffectInstance(Effects.field_76428_l, player.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.HEALTH_AFTER_KILL.get()) ? 5 : 4, 10));
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntityLiving())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((PlayerEntity)event.getEntity());
            if (werewolf.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.WOLF_PAWN.get())) {
                event.setDistance(event.getDistance() * 0.8f);
                event.setDamageMultiplier(event.getDamageMultiplier() * 0.8f);
            }
            if (werewolf.getSpecialAttributes().leap) {
                werewolf.getActionHandler().toggleAction((IAction)ModActions.LEAP.get());
            }
        }
    }

    @SubscribeEvent
    public void onEquipmentChange(LivingEquipmentChangeEvent event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity()) && WerewolfPlayer.get((PlayerEntity)event.getEntity()).getForm().isTransformed()) {
            if (event.getTo().func_190926_b()) {
                if (((PlayerEntity)event.getEntity()).func_110148_a(Attributes.field_233823_f_).func_111127_a(CLAWS) == null) {
                    // empty if block
                }
            } else {
                ((PlayerEntity)event.getEntity()).func_110148_a(Attributes.field_233823_f_).func_188479_b(CLAWS);
            }
            WerewolfPlayer.getOpt((PlayerEntity)event.getEntity()).filter(werewolf -> !werewolf.getForm().isHumanLike() || !werewolf.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.WEAR_ARMOR.get())).ifPresent(WerewolfPlayer::requestArmorEvaluation);
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity())) {
            WerewolfPlayer werewolf = WerewolfPlayer.get((PlayerEntity)event.getEntity());
            if (werewolf.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.WOLF_PAWN.get())) {
                Vector3d motion = event.getEntity().func_213322_ci().func_216372_d(1.1, 1.2, 1.1);
                event.getEntity().func_213317_d(motion);
            }
            if (werewolf.getActionHandler().isActionActive((ILastingAction)ModActions.LEAP.get())) {
                if (werewolf.getSpecialAttributes().leap) {
                    werewolf.getActionHandler().toggleAction((IAction)ModActions.LEAP.get());
                } else {
                    werewolf.getSpecialAttributes().leap = true;
                    Vector3d vector3d = event.getEntity().func_213322_ci();
                    event.getEntity().func_213293_j(vector3d.field_72450_a, vector3d.field_72448_b + (double)((LivingEntityInvoker)event.getEntity()).invokeGetJumpPower_werewolves() * 0.3, vector3d.field_72449_c);
                }
            } else {
                werewolf.getSpecialAttributes().leap = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWakeUp(PlayerWakeUpEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getPlayer().func_70660_b((Effect)ModEffects.LUPUS_SANGUINEM.get()) != null && event.getPlayer() instanceof ServerPlayerEntity && ((ServerPlayerEntity)event.getPlayer()).field_71135_a != null) {
            event.getPlayer().func_70660_b((Effect)ModEffects.LUPUS_SANGUINEM.get()).func_76457_b((LivingEntity)event.getPlayer());
            event.getPlayer().func_195063_d((Effect)ModEffects.LUPUS_SANGUINEM.get());
        }
    }

    @SubscribeEvent
    public void onItemUseEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == ModItems.V.INJECTION_EMPTY.get() && event.getTarget() instanceof WerewolfBaseEntity) {
            event.getPlayer().func_184586_b(event.getHand()).func_190918_g(1);
            event.getPlayer().func_191521_c(new ItemStack((IItemProvider)ModItems.INJECTION_UN_WEREWOLF.get()));
        }
    }

    @SubscribeEvent
    public void onItemUseBlock(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (player.func_184586_b(event.getHand()).func_77973_b() == ModItems.INJECTION_UN_WEREWOLF.get()) {
            if (event.getWorld().func_180495_p(event.getPos()).func_177230_c() == ModBlocks.V.MED_CHAIR.get()) {
                ItemStack stack = player.func_184586_b(event.getHand());
                if (player.func_70089_S()) {
                    FactionPlayerHandler handler = FactionPlayerHandler.get((PlayerEntity)event.getPlayer());
                    IPlayableFaction faction = handler.getCurrentFaction();
                    boolean used = false;
                    if (WReference.WEREWOLF_FACTION.equals((Object)faction)) {
                        if (player.func_70660_b((Effect)ModEffects.UN_WEREWOLF.get()) == null) {
                            player.func_195064_c((EffectInstance)new UnWerewolfEffectInstance(2000));
                            used = true;
                        } else {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.injection.in_use"), true);
                        }
                    } else if (faction != null) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.injection.not_use"), true);
                    }
                    if (used) {
                        stack.func_190918_g(1);
                        if (stack.func_190926_b()) {
                            player.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
            }
            event.setCancellationResult(ActionResultType.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerSize(EntityEvent.Size event) {
        LazyOptional<WerewolfPlayer> werewolf;
        Optional size;
        if (event.getEntity() instanceof PlayerEntity && ((PlayerEntity)event.getEntity()).field_71071_by != null && (size = (werewolf = WerewolfPlayer.getOpt((PlayerEntity)event.getEntity())).map(WerewolfPlayer::getForm).flatMap(form -> form.getSize(event.getPose()))).isPresent()) {
            event.setNewSize((EntitySize)size.get());
            event.setNewEyeHeight(((EntitySize)size.get()).field_220316_b * 0.85f);
        }
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        if (event.getEntity() instanceof PlayerEntity && Helper.isWerewolf((PlayerEntity)event.getEntity())) {
            if (event.getEntity().func_70051_ag() && event.getSource() instanceof EntityDamageSource) {
                WerewolfPlayer.getOpt((PlayerEntity)event.getEntity()).filter(w -> w.getForm() == WerewolfForm.SURVIVALIST).map(WerewolfPlayer::getSkillHandler).ifPresent(skillHandler -> {
                    if (skillHandler.isSkillEnabled((ISkill)WerewolfSkills.MOVEMENT_TACTICS.get())) {
                        float limit = ((Double)WerewolvesConfig.BALANCE.SKILLS.movement_tactics_doge_chance.get()).floatValue();
                        if (skillHandler.isRefinementEquipped((IRefinement)ModRefinements.GREATER_DOGE_CHANCE.get())) {
                            limit += ((Double)WerewolvesConfig.BALANCE.REFINEMENTS.greater_doge_chance.get()).floatValue();
                        }
                        if (((PlayerEntity)event.getEntity()).func_70681_au().nextFloat() < limit) {
                            event.setCanceled(true);
                        }
                    }
                });
            } else if ((event.getSource() == DamageSource.field_220302_v || event.getSource() == DamageSource.field_76367_g || event.getSource() == DamageSource.field_190095_e) && WerewolfPlayer.getOpt((PlayerEntity)event.getEntity()).filter(w -> w.getForm().isTransformed()).map(w -> w.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.WOLF_PAWN.get())).orElse(false).booleanValue()) {
                event.setCanceled(true);
            }
        }
    }
}

