/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf;

import de.teamlapen.werewolves.entities.player.werewolf.WerewolfLevelConf;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.MathHelper;

public class LevelHandler {
    private final WerewolfPlayer player;
    private int levelProgress;

    public LevelHandler(WerewolfPlayer player) {
        this.player = player;
    }

    public boolean canLevelUp() {
        return this.player.getLevel() != this.player.getMaxLevel() && this.levelProgress >= this.getNeededProgress();
    }

    public float getLevelPerc() {
        return MathHelper.func_76131_a((float)((float)this.levelProgress / (float)this.getNeededProgress()), (float)0.0f, (float)1.0f);
    }

    public void saveToNbt(@Nonnull CompoundNBT compound) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("progress", this.levelProgress);
        compound.func_218657_a("level", (INBT)nbt);
    }

    public void loadFromNbt(@Nonnull CompoundNBT compound) {
        if (compound.func_74764_b("level")) {
            this.levelProgress = compound.func_74775_l("level").func_74762_e("progress");
        }
    }

    public int getLevelProgress() {
        return this.levelProgress;
    }

    public int getNeededProgress() {
        return WerewolfLevelConf.getInstance().getRequirementOpt(this.player.getLevel() + 1).map(x -> x.xpAmount).orElse(Integer.MAX_VALUE);
    }

    public void increaseProgress(int amount) {
        this.levelProgress += amount;
    }

    public void reset() {
        this.levelProgress = 0;
    }
}

