/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.effects.WerewolfNightVisionEffect;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.LevelHandler;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayerDefaultImpl;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayerSpecialAttributes;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.mixin.ArmorItemAccessor;
import de.teamlapen.werewolves.mixin.FoodStatsAccessor;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.NBTHelper;
import de.teamlapen.werewolves.util.REFERENCE;
import de.teamlapen.werewolves.util.WReference;
import de.teamlapen.werewolves.util.WUtils;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.FoodStats;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WerewolfPlayer
extends VampirismPlayer<IWerewolfPlayer>
implements IWerewolfPlayer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final UUID ARMOR_TOUGHNESS = UUID.fromString("f3979aec-b8ef-4e95-84a7-2c6dab8ea46e");
    @CapabilityInject(value=IWerewolfPlayer.class)
    public static Capability<IWerewolfPlayer> CAP = (Capability)UtilLib.getNull();
    @Nonnull
    private final ActionHandler<IWerewolfPlayer> actionHandler;
    @Nonnull
    private final SkillHandler<IWerewolfPlayer> skillHandler;
    @Nonnull
    private final WerewolfPlayerSpecialAttributes specialAttributes = new WerewolfPlayerSpecialAttributes();
    @Nonnull
    private WerewolfForm form = WerewolfForm.NONE;
    @Nullable
    private WerewolfFormAction lastFormAction;
    @Nonnull
    private final LevelHandler levelHandler = new LevelHandler(this);
    private boolean checkArmorModifer;
    private final Map<WerewolfForm, Integer> eyeType = new HashMap<WerewolfForm, Integer>();
    private final Map<WerewolfForm, Integer> skinType = new HashMap<WerewolfForm, Integer>();
    private final Map<WerewolfForm, Boolean> glowingEyes = new HashMap<WerewolfForm, Boolean>();

    private void applyEntityAttributes() {
        try {
            this.player.func_110148_a((Attribute)ModAttributes.BITE_DAMAGE.get());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
    }

    public static WerewolfPlayer get(@Nonnull PlayerEntity playerEntity) {
        return (WerewolfPlayer)playerEntity.getCapability(CAP).orElseThrow(() -> new IllegalStateException("Cannot get werewolf player capability from player" + playerEntity));
    }

    public static LazyOptional<WerewolfPlayer> getOpt(@Nonnull PlayerEntity playerEntity) {
        LazyOptional opt = playerEntity.getCapability(CAP).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Werewolf player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    public static LazyOptional<WerewolfPlayer> getOptEx(@Nullable Entity entity) {
        if (!(entity instanceof PlayerEntity) || !Helper.isWerewolf((PlayerEntity)entity)) {
            return LazyOptional.empty();
        }
        return WerewolfPlayer.getOpt((PlayerEntity)entity);
    }

    public WerewolfPlayer(@Nonnull PlayerEntity player) {
        super(player);
        this.actionHandler = new ActionHandler((IFactionPlayer)this);
        this.skillHandler = new SkillHandler((IFactionPlayer)this, WReference.WEREWOLF_FACTION);
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    public void setForm(WerewolfFormAction action, WerewolfForm form) {
        this.switchForm(form);
        this.lastFormAction = action;
        if (!this.player.field_70170_p.field_72995_K) {
            this.sync(NBTHelper.nbtWith(nbt -> nbt.func_74778_a("form", this.form.getName())), true);
        }
    }

    public void switchForm(WerewolfForm form) {
        this.form = form;
        this.player.func_213323_x_();
    }

    protected VampirismPlayer<IWerewolfPlayer> copyFromPlayer(PlayerEntity playerEntity) {
        WerewolfPlayer oldWerewolf = WerewolfPlayer.get(playerEntity);
        CompoundNBT nbt = new CompoundNBT();
        oldWerewolf.saveData(nbt);
        this.loadData(nbt);
        return oldWerewolf;
    }

    public void requestArmorEvaluation() {
        this.checkArmorModifer = true;
    }

    public void removeArmorModifier() {
        for (UUID uuid : ArmorItemAccessor.getARMOR_MODIFIERS()) {
            this.player.func_110148_a(Attributes.field_233827_j_).func_188479_b(uuid);
            this.player.func_110148_a(Attributes.field_233826_i_).func_188479_b(uuid);
        }
    }

    public void addArmorModifier() {
        HashSet uuids = Sets.newHashSet((Object[])ArmorItemAccessor.getARMOR_MODIFIERS());
        int i = 0;
        for (ItemStack stack : this.player.func_184193_aE()) {
            EquipmentSlotType slotType = EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)i);
            ++i;
            Multimap map = stack.func_111283_C(slotType);
            for (Map.Entry entry : map.asMap().entrySet()) {
                for (AttributeModifier modifier : (Collection)entry.getValue()) {
                    ModifiableAttributeInstance attribute;
                    if (!uuids.contains(modifier.func_111167_a()) || (attribute = this.player.func_110148_a((Attribute)entry.getKey())).func_180374_a(modifier)) continue;
                    attribute.func_233769_c_(modifier);
                }
            }
        }
    }

    public void onChangedDimension(RegistryKey<World> registryKey, RegistryKey<World> registryKey1) {
    }

    @Nonnull
    public WerewolfPlayerSpecialAttributes getSpecialAttributes() {
        return this.specialAttributes;
    }

    public void onUpdate() {
        this.player.func_130014_f_().func_217381_Z().func_76320_a("werewolves_werewolfplayer");
        if (this.getLevel() > 0) {
            if (!this.isRemote()) {
                boolean sync = false;
                boolean syncToAll = false;
                CompoundNBT syncPacket = new CompoundNBT();
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    syncToAll = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (this.player.field_70170_p.func_82737_E() % 10L == 0L) {
                    if (this.specialAttributes.transformationTime > 0.0 && FormHelper.getActiveFormAction(this).map(action -> !action.consumesWerewolfTime()).orElse(true).booleanValue()) {
                        this.specialAttributes.transformationTime = MathHelper.func_151237_a((double)(this.specialAttributes.transformationTime - this.player.func_110148_a((Attribute)ModAttributes.TIME_REGAIN.get()).func_111126_e()), (double)0.0, (double)1.0);
                        syncPacket.func_74780_a("transformationTime", this.specialAttributes.transformationTime);
                    }
                    if (this.player.field_70170_p.func_82737_E() % 20L == 0L) {
                        if (Helper.isFullMoon(this.getRepresentingPlayer().func_130014_f_()) && !FormHelper.isFormActionActive(this) && !this.skillHandler.isSkillEnabled((ISkill)WerewolfSkills.FREE_WILL.get())) {
                            Optional<WerewolfFormAction> action2 = this.lastFormAction != null ? Optional.of(this.lastFormAction) : WerewolfFormAction.getAllAction().stream().filter(arg_0 -> this.actionHandler.isActionUnlocked(arg_0)).findAny();
                            action2.ifPresent(arg_0 -> this.actionHandler.toggleAction(arg_0));
                        }
                        if (this.player.func_70090_H() && this.player.func_208600_a((ITag)FluidTags.field_206959_a) && !this.skillHandler.isSkillEnabled((ISkill)WerewolfSkills.WATER_LOVER.get())) {
                            this.player.func_195064_c(new EffectInstance(Effects.field_76437_t, 50, 0, true, true));
                        }
                    }
                }
                if (this.skillHandler.isSkillEnabled((ISkill)WerewolfSkills.HEALTH_REG.get())) {
                    this.tickFoodStats();
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
                EffectInstance effect = this.player.func_70660_b(Effects.field_76439_r);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision) {
                    if (!(effect instanceof WerewolfNightVisionEffect)) {
                        if (effect != null) {
                            this.player.func_184596_c(effect.func_188419_a());
                        }
                        this.player.func_195064_c((EffectInstance)new WerewolfNightVisionEffect(effect));
                    }
                } else if (effect instanceof WerewolfNightVisionEffect) {
                    this.player.func_195063_d(effect.func_188419_a());
                    effect = ((EffectInstanceWithSource)effect).getHiddenEffect();
                    if (effect != null) {
                        this.player.func_195064_c(effect);
                    }
                }
            } else {
                this.actionHandler.updateActions();
                if (this.player.field_70170_p.func_82737_E() % 10L == 0L && this.specialAttributes.transformationTime > 0.0 && FormHelper.getActiveFormAction(this).map(action -> !action.consumesWerewolfTime()).orElse(true).booleanValue()) {
                    this.specialAttributes.transformationTime = MathHelper.func_151237_a((double)(this.specialAttributes.transformationTime - (double)((float)this.player.func_110148_a((Attribute)ModAttributes.TIME_REGAIN.get()).func_111126_e())), (double)0.0, (double)1.0);
                }
                EffectInstance effect = this.player.func_70660_b(Effects.field_76439_r);
                if (this.getForm().isTransformed() && this.specialAttributes.night_vision && !(effect instanceof WerewolfNightVisionEffect)) {
                    this.player.func_184596_c(Effects.field_76439_r);
                    this.player.func_195064_c((EffectInstance)new WerewolfNightVisionEffect());
                }
            }
            if (this.checkArmorModifer && this.form.isTransformed()) {
                if (!this.form.isHumanLike() || !this.skillHandler.isSkillEnabled((ISkill)WerewolfSkills.WEAR_ARMOR.get())) {
                    this.removeArmorModifier();
                }
                this.checkArmorModifer = false;
            }
            this.specialAttributes.biteTicks = Math.max(0, this.specialAttributes.biteTicks - 1);
        }
        this.player.func_130014_f_().func_217381_Z().func_76319_b();
    }

    private void tickFoodStats() {
        Difficulty difficulty = this.player.field_70170_p.func_175659_aa();
        boolean flag = this.player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223606_i);
        FoodStats stats = this.player.func_71024_bL();
        if (flag && stats.func_75115_e() > 0.0f && this.player.func_70996_bM() && stats.func_75116_a() >= 20) {
            if (((FoodStatsAccessor)stats).getFoodTimer() >= 9) {
                float f = Math.min(stats.func_75115_e(), 6.0f);
                this.player.func_70691_i(f / 6.0f);
                stats.func_75113_a(f);
            }
        } else if (flag && stats.func_75116_a() >= 18 && this.player.func_70996_bM()) {
            if (((FoodStatsAccessor)stats).getFoodTimer() >= 79) {
                this.player.func_70691_i(1.0f);
                stats.func_75113_a(6.0f);
            }
        } else if (stats.func_75116_a() <= 0 && ((FoodStatsAccessor)stats).getFoodTimer() >= 79 && (this.player.func_110143_aJ() > 10.0f || difficulty == Difficulty.HARD || this.player.func_110143_aJ() > 1.0f && difficulty == Difficulty.NORMAL)) {
            this.player.func_70097_a(DamageSource.field_76366_f, 1.0f);
        }
    }

    public boolean setGlowingEyes(WerewolfForm form, boolean on) {
        if (on != this.glowingEyes.getOrDefault(form, false)) {
            this.glowingEyes.put(form, on);
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                CompoundNBT glowingEyes = new CompoundNBT();
                this.glowingEyes.forEach((key, value) -> glowingEyes.func_74757_a(key.getName(), value.booleanValue()));
                nbt.func_218657_a("glowingEyes", (INBT)glowingEyes);
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setEyeType(WerewolfForm form, int type) {
        if (type != this.eyeType.getOrDefault(form, -1)) {
            this.eyeType.put(form, type);
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                CompoundNBT eye = new CompoundNBT();
                this.eyeType.forEach((key, value) -> eye.func_74768_a(key.getName(), value.intValue()));
                nbt.func_218657_a("eyeTypes", (INBT)eye);
                this.sync(nbt, true);
            }
            return true;
        }
        return false;
    }

    public boolean setSkinType(WerewolfForm form, int type) {
        if (type != this.skinType.getOrDefault(form, -1)) {
            this.skinType.put(form, type);
            if (!this.isRemote()) {
                CompoundNBT nbt = new CompoundNBT();
                CompoundNBT skin = new CompoundNBT();
                this.skinType.forEach((key, value) -> skin.func_74768_a(key.getName(), value.intValue()));
                nbt.func_218657_a("skinTypes", (INBT)skin);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void setSkinData(WerewolfForm form, int[] data) {
        this.setEyeType(form, data[0]);
        this.setSkinType(form, data[1]);
        this.setGlowingEyes(form, data[2] == 1);
    }

    public void onDeath(DamageSource damageSource) {
        super.onDeath(damageSource);
        this.actionHandler.deactivateAllActions();
    }

    @Nonnull
    public LevelHandler getLevelHandler() {
        return this.levelHandler;
    }

    public boolean onEntityAttacked(DamageSource damageSource, float v) {
        return false;
    }

    public void onEntityKilled(LivingEntity victim, DamageSource src) {
        if (this.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.RAGE_FURY.get())) {
            this.player.func_195064_c(new EffectInstance(Effects.field_76420_g, 40, 1));
            this.actionHandler.extendActionTimer((ILastingAction)ModActions.RAGE.get(), ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.rage_fury_timer_extend.get()).intValue());
        }
        this.levelHandler.increaseProgress((int)((double)victim.func_110138_aP() * 0.2));
        this.syncLevelHandler();
    }

    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
        }
    }

    public void syncLevelHandler() {
        CompoundNBT sync = new CompoundNBT();
        this.levelHandler.saveToNbt(sync);
        this.sync(sync, false);
    }

    public void onPlayerLoggedIn() {
    }

    public void onPlayerLoggedOut() {
    }

    public void onUpdatePlayer(TickEvent.Phase phase) {
    }

    public boolean canBiteEntity(LivingEntity entity) {
        return (double)entity.func_70032_d((Entity)this.player) <= this.player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0 && (!(entity instanceof PlayerEntity) || PermissionAPI.hasPermission((PlayerEntity)this.getRepresentingPlayer(), (String)"werewolves.bite.player"));
    }

    public boolean canBite() {
        return this.form.isTransformed() && !this.player.func_175149_v() && this.getLevel() > 0 && this.specialAttributes.biteTicks <= 0 && PermissionAPI.hasPermission((PlayerEntity)this.getRepresentingPlayer(), (String)"werewolves.bite");
    }

    public boolean bite(int entityId) {
        Entity entity = this.player.field_70170_p.func_73045_a(entityId);
        if (entity instanceof LivingEntity) {
            return this.bite((LivingEntity)entity);
        }
        return false;
    }

    private boolean bite(LivingEntity entity) {
        if (this.specialAttributes.biteTicks > 0) {
            return false;
        }
        if (!this.form.isTransformed()) {
            return false;
        }
        if (!this.canBite()) {
            return false;
        }
        if (!this.canBiteEntity(entity)) {
            return false;
        }
        double damage = this.player.func_110148_a((Attribute)ModAttributes.BITE_DAMAGE.get()).func_111126_e();
        boolean flag = entity.func_70097_a((DamageSource)Helper.causeWerewolfDamage(this.player), (float)damage);
        if (flag) {
            this.getRepresentingPlayer().func_184185_a((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), 1.0f, 1.0f);
            this.getRepresentingPlayer().func_213823_a((SoundEvent)ModSounds.ENTITY_WEREWOLF_BITE.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.eatEntity(entity);
            this.specialAttributes.biteTicks = (Integer)WerewolvesConfig.BALANCE.PLAYER.bite_cooldown.get();
            if (this.skillHandler.isSkillEnabled((ISkill)WerewolfSkills.STUN_BITE.get())) {
                int duration = (Integer)WerewolvesConfig.BALANCE.SKILLS.stun_bite_duration.get();
                if (this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.STUN_BITE.get())) {
                    duration += ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.stun_bite_duration_extend.get()).intValue();
                }
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.V.FREEZE.get(), duration));
            } else if (this.skillHandler.isSkillEnabled((ISkill)WerewolfSkills.BLEEDING_BITE.get())) {
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.BLEEDING.get(), ((Integer)WerewolvesConfig.BALANCE.SKILLS.bleeding_bite_duration.get()).intValue(), this.skillHandler.isRefinementEquipped((IRefinement)ModRefinements.BLEEDING_BITE.get()) ? 3 : 0));
            }
            this.sync(NBTHelper.nbtWith(nbt -> nbt.func_74768_a("biteTicks", this.specialAttributes.biteTicks)), false);
            if (!(entity instanceof PlayerEntity) || PermissionAPI.hasPermission((PlayerEntity)this.getRepresentingPlayer(), (String)"werewolves.infect")) {
                LupusSanguinemEffect.addSanguinemEffectRandom(entity, 0.1f);
            }
        }
        return flag;
    }

    private void eatEntity(LivingEntity entity) {
        if (entity.func_70662_br()) {
            return;
        }
        if (!entity.func_70089_S() && entity.func_200600_R().func_220339_d().func_82705_e()) {
            this.player.func_71024_bL().func_75122_a(1, 1.0f);
        }
    }

    public void onLevelChanged(int newLevel, int oldLevel) {
        this.applyEntityAttributes();
        if (!this.isRemote()) {
            ScoreboardUtil.updateScoreboard((PlayerEntity)this.player, (ScoreCriteria)WUtils.WEREWOLF_LEVEL_CRITERIA, (int)newLevel);
            LevelAttributeModifier.applyModifier((PlayerEntity)this.player, (Attribute)Attributes.field_233821_d_, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.3, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((PlayerEntity)this.player, (Attribute)Attributes.field_233827_j_, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_speed_amount.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_TOTAL, (boolean)false);
            LevelAttributeModifier.applyModifier((PlayerEntity)this.player, (Attribute)Attributes.field_233823_f_, (String)"Werewolf", (int)this.getLevel(), (int)this.getMaxLevel(), (double)((Double)WerewolvesConfig.BALANCE.PLAYER.werewolf_damage.get()), (double)0.5, (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION, (boolean)false);
            if (newLevel > 0) {
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill();
                }
            } else {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
                this.skillHandler.resetRefinements();
            }
        } else if (newLevel == 0) {
            this.actionHandler.resetTimers();
            this.skillHandler.resetRefinements();
        }
    }

    private void eatFleshFrom(LivingEntity entity) {
        this.player.func_71024_bL().func_75122_a(1, 1.0f);
    }

    public ResourceLocation getCapKey() {
        return REFERENCE.WEREWOLF_PLAYER_KEY;
    }

    public boolean canLeaveFaction() {
        return true;
    }

    @Nullable
    public IFaction<?> getDisguisedAs() {
        if (this.getForm().isTransformed()) {
            return WReference.WEREWOLF_FACTION;
        }
        return null;
    }

    public IPlayableFaction<IWerewolfPlayer> getFaction() {
        return WReference.WEREWOLF_FACTION;
    }

    public int getMaxLevel() {
        return 14;
    }

    public Predicate<LivingEntity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return entity -> true;
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    public boolean isDisguised() {
        return !this.getForm().isTransformed();
    }

    @Nullable
    public WerewolfFormAction getLastFormAction() {
        return this.lastFormAction;
    }

    public ISkillHandler<IWerewolfPlayer> getSkillHandler() {
        return this.skillHandler;
    }

    public IActionHandler<IWerewolfPlayer> getActionHandler() {
        return this.actionHandler;
    }

    public void saveData(CompoundNBT compound) {
        super.saveData(compound);
        this.actionHandler.saveToNbt(compound);
        this.skillHandler.saveToNbt(compound);
        this.levelHandler.saveToNbt(compound);
        compound.func_74778_a("form", this.form.getName());
        if (this.lastFormAction != null) {
            compound.func_74778_a("lastFormAction", this.lastFormAction.getRegistryName().toString());
        }
        compound.func_74768_a("biteTicks", this.specialAttributes.biteTicks);
        CompoundNBT eye = new CompoundNBT();
        this.eyeType.forEach((key, value) -> eye.func_74768_a(key.getName(), value.intValue()));
        compound.func_218657_a("eyeTypes", (INBT)eye);
        CompoundNBT skin = new CompoundNBT();
        this.skinType.forEach((key, value) -> skin.func_74768_a(key.getName(), value.intValue()));
        compound.func_218657_a("skinTypes", (INBT)skin);
        CompoundNBT glowingEye = new CompoundNBT();
        this.glowingEyes.forEach((key, value) -> glowingEye.func_74757_a(key.getName(), value.booleanValue()));
        compound.func_218657_a("glowingEyes", (INBT)glowingEye);
        compound.func_74780_a("transformationTime", this.specialAttributes.transformationTime);
    }

    public void loadData(CompoundNBT compound) {
        super.loadData(compound);
        this.actionHandler.loadFromNbt(compound);
        this.skillHandler.loadFromNbt(compound);
        this.levelHandler.loadFromNbt(compound);
        CompoundNBT armor = compound.func_74775_l("armor");
        for (int i = 0; i < armor.func_186856_d(); ++i) {
            try {
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)armor.func_74775_l("" + i));
                this.player.func_184201_a(EquipmentSlotType.values()[i], stack);
                continue;
            }
            catch (Exception stack) {
                // empty catch block
            }
        }
        if (NBTHelper.containsString(compound, "form")) {
            this.switchForm(WerewolfForm.getForm(compound.func_74779_i("form")));
        }
        if (NBTHelper.containsString(compound, "lastFormAction")) {
            this.lastFormAction = (WerewolfFormAction)ModRegistries.ACTIONS.getValue(new ResourceLocation(compound.func_74779_i("lastFormAction")));
        }
        this.specialAttributes.biteTicks = compound.func_74762_e("biteTicks");
        CompoundNBT eye = compound.func_74775_l("eyeTypes");
        eye.func_150296_c().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.func_74762_e(string)));
        CompoundNBT skin = compound.func_74775_l("skinTypes");
        skin.func_150296_c().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.func_74762_e(string)));
        CompoundNBT glowingEyes = compound.func_74775_l("glowingEyes");
        glowingEyes.func_150296_c().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.func_74767_n(string)));
        if (compound.func_74764_b("transformationTime")) {
            this.specialAttributes.transformationTime = compound.func_74760_g("transformationTime");
        }
    }

    protected void writeFullUpdate(CompoundNBT nbt) {
        super.writeFullUpdate(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
        this.levelHandler.saveToNbt(nbt);
        nbt.func_74778_a("form", this.form.getName());
        nbt.func_74768_a("biteTicks", this.specialAttributes.biteTicks);
        CompoundNBT eye = new CompoundNBT();
        this.eyeType.forEach((key, value) -> eye.func_74768_a(key.getName(), value.intValue()));
        nbt.func_218657_a("eyeTypes", (INBT)eye);
        CompoundNBT skin = new CompoundNBT();
        this.skinType.forEach((key, value) -> skin.func_74768_a(key.getName(), value.intValue()));
        nbt.func_218657_a("skinTypes", (INBT)skin);
        CompoundNBT glowingEye = new CompoundNBT();
        this.glowingEyes.forEach((key, value) -> glowingEye.func_74757_a(key.getName(), value.booleanValue()));
        nbt.func_218657_a("glowingEyes", (INBT)glowingEye);
        nbt.func_74780_a("transformationTime", this.specialAttributes.transformationTime);
    }

    protected void loadUpdate(CompoundNBT nbt) {
        super.loadUpdate(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
        this.levelHandler.loadFromNbt(nbt);
        if (NBTHelper.containsString(nbt, "form")) {
            this.switchForm(WerewolfForm.getForm(nbt.func_74779_i("form")));
        }
        if (nbt.func_74764_b("biteTicks")) {
            this.specialAttributes.biteTicks = nbt.func_74762_e("biteTicks");
        }
        if (nbt.func_74764_b("eyeTypes")) {
            CompoundNBT eye = nbt.func_74775_l("eyeTypes");
            eye.func_150296_c().forEach(string -> this.eyeType.put(WerewolfForm.getForm(string), eye.func_74762_e(string)));
        }
        if (nbt.func_74764_b("skinTypes")) {
            CompoundNBT skin = nbt.func_74775_l("skinTypes");
            skin.func_150296_c().forEach(string -> this.skinType.put(WerewolfForm.getForm(string), skin.func_74762_e(string)));
        }
        if (nbt.func_74764_b("glowingEyes")) {
            CompoundNBT glowingEyes = nbt.func_74775_l("glowingEyes");
            glowingEyes.func_150296_c().forEach(string -> this.glowingEyes.put(WerewolfForm.getForm(string), glowingEyes.func_74767_n(string)));
        }
        if (nbt.func_74764_b("transformationTime")) {
            this.specialAttributes.transformationTime = nbt.func_74760_g("transformationTime");
        }
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IWerewolfPlayer.class, (Capability.IStorage)new Storage(), WerewolfPlayerDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final PlayerEntity playerEntity) {
        return new ICapabilitySerializable<CompoundNBT>(){
            final IWerewolfPlayer inst;
            final LazyOptional<IWerewolfPlayer> opt;
            {
                this.inst = new WerewolfPlayer(playerEntity);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CAP.orEmpty(cap, this.opt);
            }

            public CompoundNBT serializeNBT() {
                return (CompoundNBT)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }

            public void deserializeNBT(CompoundNBT nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (INBT)nbt);
            }
        };
    }

    @Override
    public int getEyeType(@Nonnull WerewolfForm form) {
        return this.eyeType.getOrDefault(form, 0);
    }

    @Override
    public int getSkinType(@Nonnull WerewolfForm form) {
        return this.skinType.getOrDefault(form, 0);
    }

    @Override
    public boolean hasGlowingEyes(@Nonnull WerewolfForm form) {
        return this.glowingEyes.getOrDefault(form, false);
    }

    static {
        LevelAttributeModifier.registerModdedAttributeModifier((Attribute)Attributes.field_233827_j_, (UUID)ARMOR_TOUGHNESS);
    }

    private static class Storage
    implements Capability.IStorage<IWerewolfPlayer> {
        private Storage() {
        }

        @Nullable
        public INBT writeNBT(Capability<IWerewolfPlayer> capability, IWerewolfPlayer instance, Direction side) {
            CompoundNBT compound = new CompoundNBT();
            ((WerewolfPlayer)instance).saveData(compound);
            return compound;
        }

        public void readNBT(Capability<IWerewolfPlayer> capability, IWerewolfPlayer instance, Direction side, INBT compound) {
            ((WerewolfPlayer)instance).loadData((CompoundNBT)compound);
        }
    }
}

