/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeConfigSpec;

public class BeastWerewolfFormAction
extends WerewolfFormAction {
    public BeastWerewolfFormAction() {
        super(WerewolfForm.BEAST);
        this.attributes.add(new WerewolfFormAction.Modifier((Supplier<Attribute>)ModAttributes.BITE_DAMAGE, UUID.fromString("128d73ba-f99a-452a-96fc-494c317ee7e3"), UUID.fromString("4e32baca-7752-4323-8942-76891822e836"), 1.0, "beast_form_claw_damage", () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.beast_form_bite_damage).get(), AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233818_a_, UUID.fromString("5b99db11-01cf-4430-bf41-ff6adc11ccb0"), UUID.fromString("d41d9079-15a0-414d-847e-8708b9226be5"), 0.5, "beast_form_health", () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.beast_form_health).get(), AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233826_i_, UUID.fromString("0b281a87-829f-4d98-9a3b-116549cfdd57"), UUID.fromString("faebe9f8-d133-44a7-b872-83560ca4d927"), 0.7, "beast_form_armor", () -> (Double)WerewolvesConfig.BALANCE.SKILLS.beast_form_armor.get() * 0.8, () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.beast_form_armor).get(), (Supplier<ISkill>)WerewolfSkills.RESISTANCE, AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233827_j_, UUID.fromString("f47e2130-39c4-496f-8d47-572abdc03920"), UUID.fromString("b8eb47be-1e10-41ce-8ff6-2a5c4aa4f408"), 0.7, "beast_form_armor_toughness", () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.beast_form_armor_toughness).get(), AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233821_d_, UUID.fromString("e9748d20-a9a5-470c-99a4-44167df71aa5"), UUID.fromString("cf0d3fce-6fb3-4274-842b-bced59637eaf"), 0.5, "beast_form_speed_amount", () -> (Double)WerewolvesConfig.BALANCE.SKILLS.beast_form_speed_amount.get() * 0.8, () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.beast_form_speed_amount).get(), (Supplier<ISkill>)WerewolfSkills.SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233823_f_, UUID.fromString("2792aac3-5ae1-47d9-8ba6-0b473b6b666a"), UUID.fromString("07a8e8e1-ff43-41f9-8053-c947482ef6c2"), 0.5, "beast_form_attack_damage", () -> (Double)WerewolvesConfig.BALANCE.SKILLS.beast_form_attack_damage.get() * 0.5, () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.beast_form_attack_damage).get(), (Supplier<ISkill>)WerewolfSkills.DAMAGE, AttributeModifier.Operation.ADDITION));
    }

    public boolean isEnabled() {
        return (Boolean)WerewolvesConfig.BALANCE.SKILLS.beast_form_enabled.get();
    }

    public int getCooldown() {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.beast_form_cooldown.get() * 20;
    }

    @Override
    public int getTimeModifier(IWerewolfPlayer werewolf) {
        int limit = super.getTimeModifier(werewolf);
        boolean duration1 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_BEAST_1.get());
        boolean duration2 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_BEAST_2.get());
        if (duration1 || duration2) {
            limit = duration2 ? (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_beast_2.get() * 20) : (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_beast_1.get() * 20);
        }
        return limit;
    }
}

