/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModEffects;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.entities.AggressiveWolfEntity;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.DefaultWerewolfAction;
import de.teamlapen.werewolves.entities.player.werewolf.actions.IActionCooldownMenu;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HowlingAction
extends DefaultWerewolfAction
implements IActionCooldownMenu {
    public boolean isEnabled() {
        return (Boolean)WerewolvesConfig.BALANCE.SKILLS.howling_enabled.get();
    }

    protected boolean activate(IWerewolfPlayer werewolfPlayer) {
        PlayerEntity player = werewolfPlayer.getRepresentingPlayer();
        if (player.func_70660_b((Effect)ModEffects.HOWLING.get()) != null) {
            return false;
        }
        AxisAlignedBB bb = new AxisAlignedBB(player.func_233580_cy_());
        bb.func_186662_g(10.0);
        List entities = player.func_130014_f_().func_217357_a(LivingEntity.class, bb);
        entities.forEach(entity -> entity.func_195064_c(new EffectInstance((Effect)ModEffects.HOWLING.get(), ((Integer)WerewolvesConfig.BALANCE.SKILLS.howling_duration.get() + (Integer)WerewolvesConfig.BALANCE.SKILLS.howling_disabled_duration.get()) * 20, 0, true, false, true)));
        werewolfPlayer.getRepresentingPlayer().func_184185_a((SoundEvent)ModSounds.ENTITY_WEREWOLF_HOWL.get(), 1.0f, 1.0f);
        werewolfPlayer.getRepresentingPlayer().func_213823_a((SoundEvent)ModSounds.ENTITY_WEREWOLF_HOWL.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        if (werewolfPlayer.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.WOLF_PACK.get())) {
            World world = player.func_130014_f_();
            int wolfAmount = (Integer)WerewolvesConfig.BALANCE.SKILLS.wolf_pack_wolf_amount.get();
            if (werewolfPlayer.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.MORE_WOLVES.get())) {
                wolfAmount += ((Integer)WerewolvesConfig.BALANCE.REFINEMENTS.more_wolves.get()).intValue();
            }
            for (int i = 0; i < wolfAmount; ++i) {
                ModEntities.WOLF.map(a -> (AggressiveWolfEntity)a.func_200721_a(world)).ifPresent(wolf -> {
                    wolf.func_193101_c(player);
                    wolf.restrictLiveSpan((Integer)WerewolvesConfig.BALANCE.SKILLS.wolf_pack_wolf_duration.get() * 20);
                    UtilLib.spawnEntityInWorld((ServerWorld)((ServerWorld)world), (AxisAlignedBB)new AxisAlignedBB(player.func_233580_cy_()).func_186662_g(1.0), (Entity)wolf, (int)10, new ArrayList(), (SpawnReason)SpawnReason.EVENT);
                });
            }
        }
        return true;
    }

    public boolean canBeUsedBy(IWerewolfPlayer player) {
        return player.getRepresentingPlayer().func_70660_b((Effect)ModEffects.HOWLING.get()) == null;
    }

    public int getCooldown() {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.howling_cooldown.get() * 20;
    }
}

