/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.DefaultWerewolfAction;
import de.teamlapen.werewolves.entities.player.werewolf.actions.IActionCooldownMenu;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;

public class RageWerewolfAction
extends DefaultWerewolfAction
implements ILastingAction<IWerewolfPlayer>,
IActionCooldownMenu {
    private static final UUID BITE_MODIFIER = UUID.fromString("0ae51804-eaf4-456e-b4ff-24ed326557f4");

    public boolean isEnabled() {
        return (Boolean)WerewolvesConfig.BALANCE.SKILLS.rage_enabled.get();
    }

    protected boolean activate(IWerewolfPlayer werewolf) {
        this.addEffectInstance(werewolf, new EffectInstance(Effects.field_76424_c, this.getDuration(werewolf.getLevel()), 1, false, false));
        this.addEffectInstance(werewolf, new EffectInstance(Effects.field_76420_g, this.getDuration(werewolf.getLevel()), 0, false, false));
        werewolf.getRepresentingPlayer().func_110148_a((Attribute)ModAttributes.BITE_DAMAGE.get()).func_233769_c_(new AttributeModifier(BITE_MODIFIER, "rage_bite_modifier", ((Double)WerewolvesConfig.BALANCE.SKILLS.rage_bite_damage.get()).doubleValue(), AttributeModifier.Operation.ADDITION));
        return true;
    }

    public int getDuration(int i) {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.rage_duration.get() * 20;
    }

    public void onActivatedClient(IWerewolfPlayer iWerewolfPlayer) {
    }

    public void onDeactivated(IWerewolfPlayer werewolf) {
        this.removePotionEffect(werewolf, Effects.field_76420_g);
        this.removePotionEffect(werewolf, Effects.field_76424_c);
        werewolf.getRepresentingPlayer().func_110148_a((Attribute)ModAttributes.BITE_DAMAGE.get()).func_188479_b(BITE_MODIFIER);
    }

    public void onReActivated(IWerewolfPlayer iWerewolfPlayer) {
    }

    public boolean onUpdate(IWerewolfPlayer iWerewolfPlayer) {
        return false;
    }

    public int getCooldown() {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.rage_cooldown.get() * 20;
    }
}

