/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModAttributes;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeConfigSpec;

public class SurvivalWerewolfFormAction
extends WerewolfFormAction {
    public SurvivalWerewolfFormAction() {
        super(WerewolfForm.SURVIVALIST);
        this.attributes.add(new WerewolfFormAction.Modifier((Supplier<Attribute>)ModAttributes.BITE_DAMAGE, UUID.fromString("7c2ab40d-b71a-4453-aa95-158f69c87696"), UUID.fromString("913462ef-a612-4d2a-a797-525d0535f8d2"), 1.0, "survival_form_claw_damage", () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.survival_form_bite_damage).get(), AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233818_a_, UUID.fromString("d15ec6ad-9dc9-4ff0-ab86-acb502e7670d"), UUID.fromString("f9ee0de4-5903-452a-b42a-ab99d1e89bcf"), 0.5, "survival_form_health", () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.survival_form_health).get(), AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233826_i_, UUID.fromString("d45bf864-acab-4fb9-9440-0319483e7fdb"), UUID.fromString("2eff230c-b652-4d61-961b-cc992d9eec8a"), 0.7, "survival_form_armor", () -> (Double)WerewolvesConfig.BALANCE.SKILLS.survival_form_armor.get() * 0.8, () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.survival_form_armor).get(), (Supplier<ISkill>)WerewolfSkills.RESISTANCE, AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233827_j_, UUID.fromString("ad6a329c-5ca0-4b7b-8bd5-f3f17f3fba00"), UUID.fromString("724e45dd-7454-4c6c-96e0-b485a010e5c0"), 0.7, "survival_form_armor_toughness", () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.survival_form_armor_toughness).get(), AttributeModifier.Operation.ADDITION));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233821_d_, UUID.fromString("429ac45a-05e7-4102-b506-e1f1a3a6aca9"), UUID.fromString("0d027b0c-b87b-484c-b4ca-36bae0a2f9b9"), 0.6, "survival_form_armor_speed", () -> (Double)WerewolvesConfig.BALANCE.SKILLS.survival_form_speed_amount.get() * 0.8, () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.survival_form_speed_amount).get(), (Supplier<ISkill>)WerewolfSkills.SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.attributes.add(new WerewolfFormAction.Modifier(() -> Attributes.field_233823_f_, UUID.fromString("4e36859f-fadd-43cb-8e0d-722b7ab2cd4c"), UUID.fromString("a62d12ee-20e1-4169-a802-1eab2d0cc471"), 0.5, "survival_form_attack_damage", () -> (Double)WerewolvesConfig.BALANCE.SKILLS.survival_form_attack_damage.get() * 0.5, () -> ((ForgeConfigSpec.DoubleValue)WerewolvesConfig.BALANCE.SKILLS.survival_form_attack_damage).get(), (Supplier<ISkill>)WerewolfSkills.DAMAGE, AttributeModifier.Operation.ADDITION));
    }

    @Override
    protected boolean activate(IWerewolfPlayer werewolf) {
        if (super.activate(werewolf)) {
            if (werewolf.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.CLIMBER.get())) {
                werewolf.getRepresentingPlayer().field_70138_W = 1.0f;
            }
            return true;
        }
        return false;
    }

    @Override
    public void onActivatedClient(IWerewolfPlayer werewolfPlayer) {
        super.onActivatedClient(werewolfPlayer);
        if (werewolfPlayer.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.CLIMBER.get())) {
            werewolfPlayer.getRepresentingPlayer().field_70138_W = 1.0f;
        }
    }

    @Override
    public void onDeactivated(IWerewolfPlayer werewolf) {
        super.onDeactivated(werewolf);
        werewolf.getRepresentingPlayer().field_70138_W = 0.6f;
    }

    public boolean isEnabled() {
        return (Boolean)WerewolvesConfig.BALANCE.SKILLS.survival_form_enabled.get();
    }

    public int getCooldown() {
        return (Integer)WerewolvesConfig.BALANCE.SKILLS.survival_form_cooldown.get() * 20;
    }

    @Override
    public int getTimeModifier(IWerewolfPlayer werewolf) {
        int limit = super.getTimeModifier(werewolf);
        boolean duration1 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_SURVIVAL_1.get());
        boolean duration2 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_SURVIVAL_2.get());
        if (duration1 || duration2) {
            limit = duration2 ? (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_survival_2.get() * 20) : (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_survival_1.get() * 20);
        }
        return limit;
    }
}

