/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.actions;

import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.refinement.IRefinement;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModRefinements;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.DefaultWerewolfAction;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraftforge.server.permission.PermissionAPI;

public abstract class WerewolfFormAction
extends DefaultWerewolfAction
implements ILastingAction<IWerewolfPlayer> {
    private static final Set<WerewolfFormAction> ALL_ACTION = new HashSet<WerewolfFormAction>();
    protected final List<Modifier> attributes = new ArrayList<Modifier>();
    @Nonnull
    private final WerewolfForm form;

    public static boolean isWerewolfFormActionActive(IActionHandler<IWerewolfPlayer> handler) {
        return ALL_ACTION.stream().anyMatch(arg_0 -> handler.isActionActive(arg_0));
    }

    public static Set<WerewolfFormAction> getAllAction() {
        return Collections.unmodifiableSet(ALL_ACTION);
    }

    public WerewolfFormAction(@Nonnull WerewolfForm form) {
        ALL_ACTION.add(this);
        this.form = form;
    }

    protected boolean activate(IWerewolfPlayer werewolf) {
        float healthPerc = werewolf.getRepresentingPlayer().func_110143_aJ() / werewolf.getRepresentingPlayer().func_110138_aP();
        if (WerewolfFormAction.isWerewolfFormActionActive((IActionHandler<IWerewolfPlayer>)werewolf.getActionHandler())) {
            FormHelper.deactivateWerewolfActions(werewolf);
        }
        ((WerewolfPlayer)werewolf).setForm(this, this.form);
        this.removeArmorModifier(werewolf);
        this.applyModifier(werewolf);
        werewolf.getRepresentingPlayer().func_70606_j(werewolf.getRepresentingPlayer().func_110138_aP() * healthPerc);
        werewolf.getRepresentingPlayer().refreshDisplayName();
        return true;
    }

    protected void removeArmorModifier(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).removeArmorModifier();
    }

    protected void addArmorModifier(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).addArmorModifier();
    }

    public void onActivatedClient(IWerewolfPlayer werewolfPlayer) {
        ((WerewolfPlayer)werewolfPlayer).switchForm(this.form);
        werewolfPlayer.getRepresentingPlayer().refreshDisplayName();
    }

    public void onDeactivated(IWerewolfPlayer werewolf) {
        float healthPerc = werewolf.getRepresentingPlayer().func_110143_aJ() / werewolf.getRepresentingPlayer().func_110138_aP();
        ((WerewolfPlayer)werewolf).setForm(this, WerewolfForm.NONE);
        this.addArmorModifier(werewolf);
        this.removeModifier(werewolf);
        werewolf.getRepresentingPlayer().func_70606_j(werewolf.getRepresentingPlayer().func_110138_aP() * healthPerc);
        werewolf.getRepresentingPlayer().refreshDisplayName();
    }

    public void onReActivated(IWerewolfPlayer werewolf) {
        this.removeArmorModifier(werewolf);
        werewolf.getRepresentingPlayer().refreshDisplayName();
    }

    public boolean onUpdate(IWerewolfPlayer werewolfPlayer) {
        if (werewolfPlayer.getRepresentingPlayer().field_70170_p.func_82737_E() % 20L == 0L) {
            this.checkDayNightModifier(werewolfPlayer);
        }
        if (!this.usesTransformationTime((LivingEntity)werewolfPlayer.getRepresentingPlayer())) {
            return false;
        }
        return this.increaseWerewolfTime(werewolfPlayer) || !PermissionAPI.hasPermission((PlayerEntity)werewolfPlayer.getRepresentingPlayer(), (String)"werewolves.form");
    }

    protected boolean usesTransformationTime(LivingEntity player) {
        return !Helper.isNight(player.field_70170_p) && !FormHelper.isInWerewolfBiome((IWorld)player.field_70170_p, player.func_233580_cy_());
    }

    protected boolean increaseWerewolfTime(IWerewolfPlayer werewolfPlayer) {
        if (!this.consumesWerewolfTime()) {
            return false;
        }
        ((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().transformationTime = MathHelper.func_151237_a((double)(((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().transformationTime + 1.0 / (double)this.getTimeModifier(werewolfPlayer)), (double)0.0, (double)1.0);
        return ((WerewolfPlayer)werewolfPlayer).getSpecialAttributes().transformationTime == 1.0;
    }

    public void checkDayNightModifier(IWerewolfPlayer werewolfPlayer) {
        PlayerEntity player = werewolfPlayer.getRepresentingPlayer();
        boolean night = Helper.isNight(player.func_130014_f_());
        for (Modifier attribute : this.attributes) {
            if (player.func_110148_a(attribute.attribute.get()).func_111127_a(!night ? attribute.nightUuid : attribute.dayUuid) == null) continue;
            this.removeModifier(werewolfPlayer);
            this.applyModifier(werewolfPlayer);
        }
    }

    public void applyModifier(IWerewolfPlayer werewolf) {
        PlayerEntity player = werewolf.getRepresentingPlayer();
        boolean night = Helper.isNight(player.func_130014_f_());
        for (Modifier attribute : this.attributes) {
            ModifiableAttributeInstance ins = player.func_110148_a(attribute.attribute.get());
            if (ins == null || ins.func_111127_a(attribute.dayUuid) != null) continue;
            ins.func_233769_c_(attribute.create(werewolf, night));
        }
    }

    public void removeModifier(IWerewolfPlayer werewolf) {
        PlayerEntity player = werewolf.getRepresentingPlayer();
        for (Modifier attribute : this.attributes) {
            ModifiableAttributeInstance ins = player.func_110148_a(attribute.attribute.get());
            if (ins == null) continue;
            ins.func_188479_b(attribute.dayUuid);
            ins.func_188479_b(attribute.nightUuid);
        }
    }

    public int getDuration(int level) {
        return 0x7FFFFFFE;
    }

    public boolean canBeUsedBy(IWerewolfPlayer player) {
        if (!PermissionAPI.hasPermission((PlayerEntity)player.getRepresentingPlayer(), (String)"werewolves.form.transform") || !PermissionAPI.hasPermission((PlayerEntity)player.getRepresentingPlayer(), (String)"werewolves.form")) {
            return false;
        }
        boolean active = player.getActionHandler().isActionActive((ILastingAction)this);
        if (Helper.isFullMoon(player.getRepresentingPlayer().func_130014_f_()) && active) {
            return false;
        }
        return this.consumesWerewolfTime() || active || ((WerewolfPlayer)player).getSpecialAttributes().transformationTime < 0.7 || player.getRepresentingPlayer().field_70170_p.func_226691_t_(player.getRepresentingEntity().func_233580_cy_()) == ModBiomes.WEREWOLF_HEAVEN.get();
    }

    public boolean consumesWerewolfTime() {
        return true;
    }

    public int getTimeModifier(IWerewolfPlayer werewolf) {
        int limit = (Integer)WerewolvesConfig.BALANCE.SKILLS.werewolf_form_time_limit.get() * 20;
        boolean duration1 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_GENERAL_1.get());
        boolean duration2 = werewolf.getSkillHandler().isRefinementEquipped((IRefinement)ModRefinements.WEREWOLF_FORM_DURATION_GENERAL_2.get());
        if (duration1 || duration2) {
            limit = duration2 ? (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_general_2.get() * 20) : (limit += (Integer)WerewolvesConfig.BALANCE.REFINEMENTS.werewolf_form_duration_general_1.get() * 20);
        }
        return limit;
    }

    protected static class Modifier {
        public final Supplier<Attribute> attribute;
        public final UUID dayUuid;
        public final UUID nightUuid;
        public final String name;
        public final Function<IWerewolfPlayer, Double> value;
        public final AttributeModifier.Operation operation;
        public final double dayModifier;

        public Modifier(Supplier<Attribute> attribute, UUID dayUuid, UUID nightUuid, double dayModifier, String name, Supplier<Double> valueFunction, AttributeModifier.Operation operation) {
            this(attribute, dayUuid, nightUuid, dayModifier, name, (IWerewolfPlayer player) -> (Double)valueFunction.get(), operation);
        }

        public Modifier(Supplier<Attribute> attribute, UUID dayUuid, UUID nightUuid, double dayModifier, String name, Supplier<Double> valueFunction, Supplier<Double> extendedValueFunction, Supplier<ISkill> extendedSkill, AttributeModifier.Operation operation) {
            this(attribute, dayUuid, nightUuid, dayModifier, name, (IWerewolfPlayer player) -> player.getSkillHandler().isSkillEnabled((ISkill)extendedSkill.get()) ? (Double)extendedValueFunction.get() : (Double)valueFunction.get(), operation);
        }

        public Modifier(Supplier<Attribute> attribute, UUID dayUuid, UUID nightUuid, double dayModifier, String name, Function<IWerewolfPlayer, Double> valueFunction, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.dayUuid = dayUuid;
            this.nightUuid = nightUuid;
            this.name = name;
            this.value = valueFunction;
            this.operation = operation;
            this.dayModifier = dayModifier;
        }

        public AttributeModifier create(IWerewolfPlayer player, boolean night) {
            return new AttributeModifier(night ? this.nightUuid : this.dayUuid, this.name, night ? this.value.apply(player) : this.value.apply(player) * this.dayModifier, this.operation);
        }
    }
}

