/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.player.werewolf.skill;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.player.skills.VampirismSkill;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WReference;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SimpleWerewolfSkill
extends VampirismSkill<IWerewolfPlayer> {
    public SimpleWerewolfSkill() {
        this(false);
    }

    public SimpleWerewolfSkill(boolean desc) {
        if (desc) {
            this.setHasDefaultDescription();
        }
    }

    @Nonnull
    public IPlayableFaction<?> getFaction() {
        return WReference.WEREWOLF_FACTION;
    }

    public SimpleWerewolfSkill defaultDescWithExtra(Supplier<ITextComponent> text) {
        this.setDescription(() -> new TranslationTextComponent(this.getTranslationKey() + ".desc").func_240702_b_("\n").func_230529_a_((ITextComponent)text.get()));
        return this;
    }

    @SafeVarargs
    public final SimpleWerewolfSkill defaultDescWithExtra(TranslationTextComponent prefix, Supplier<ISkill> ... skills) {
        this.setDescription(() -> {
            IFormattableTextComponent text = new TranslationTextComponent(this.getTranslationKey() + ".desc").func_240702_b_("\n").func_230529_a_((ITextComponent)prefix.func_240699_a_(TextFormatting.AQUA)).func_240702_b_(" ");
            text.func_230529_a_((ITextComponent)Helper.joinComponents(", ", (IFormattableTextComponent[])Arrays.stream(skills).map(skill -> new TranslationTextComponent(((ISkill)skill.get()).getTranslationKey())).toArray(IFormattableTextComponent[]::new)).func_240699_a_(TextFormatting.AQUA));
            return text;
        });
        return this;
    }

    @SafeVarargs
    public final SimpleWerewolfSkill defaultDescWithFormRequirement(Supplier<ISkill> ... skills) {
        return this.defaultDescWithExtra(new TranslationTextComponent("text.werewolves.skills.only_applies"), skills);
    }

    @SafeVarargs
    public final SimpleWerewolfSkill defaultDescWithEnhancement(Supplier<ISkill> ... skill) {
        return this.defaultDescWithExtra(new TranslationTextComponent("text.werewolves.skills.upgrade"), skill);
    }

    public static class AttributeSkill
    extends SimpleWerewolfSkill {
        private final UUID attribute;
        private final Attribute attributeType;
        private final AttributeModifier.Operation operation;
        private final Function<IWerewolfPlayer, Double> attribute_value;

        public AttributeSkill(boolean desc, UUID attributeUUID, Attribute attributeType, AttributeModifier.Operation operation, Function<IWerewolfPlayer, Double> attribute_value) {
            super(desc);
            this.attribute = attributeUUID;
            this.attributeType = attributeType;
            this.operation = operation;
            this.attribute_value = attribute_value;
        }

        protected void onDisabled(IWerewolfPlayer player) {
            ModifiableAttributeInstance attributes = player.getRepresentingPlayer().func_110148_a(this.attributeType);
            attributes.func_188479_b(this.attribute);
        }

        protected void onEnabled(IWerewolfPlayer player) {
            ModifiableAttributeInstance attributes = player.getRepresentingPlayer().func_110148_a(this.attributeType);
            if (attributes.func_111127_a(this.attribute) == null) {
                attributes.func_233769_c_(new AttributeModifier(this.attribute, this.getRegistryName().toString() + "_skill", this.attribute_value.apply(player).doubleValue(), this.operation));
            }
        }
    }

    public static class LordWerewolfSkill
    extends SimpleWerewolfSkill {
        public LordWerewolfSkill(boolean desc) {
            super(desc);
        }

        public ISkillType getType() {
            return SkillType.LORD;
        }
    }
}

