/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.world.ICaptureAttributes;
import de.teamlapen.vampirism.effects.BadOmenEffect;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.world.MinionWorldData;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.entities.IEntityFollower;
import de.teamlapen.werewolves.entities.goals.DefendLeaderGoal;
import de.teamlapen.werewolves.entities.goals.FollowAlphaWerewolfGoal;
import de.teamlapen.werewolves.entities.goals.WerewolfAttackVillageGoal;
import de.teamlapen.werewolves.entities.goals.WerewolfDefendVillageGoal;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WerewolfForm;
import de.teamlapen.werewolves.util.WerewolfVillageData;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class BasicWerewolfEntity
extends WerewolfBaseEntity
implements WerewolfTransformable,
IAdjustableLevel,
IFactionEntity,
IVillageCaptureEntity,
IEntityFollower {
    protected static final DataParameter<Integer> SKINTYPE = EntityDataManager.func_187226_a(BasicWerewolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> EYETYPE = EntityDataManager.func_187226_a(BasicWerewolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(BasicWerewolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final int MAX_LEVEL = 2;
    private final WerewolfForm werewolfForm;
    private WerewolfTransformable transformed;
    private int transformedDuration;
    private WerewolfTransformable.TransformType transformType;
    private EntityClassType entityClass;
    private EntityActionTier entityTier;
    private IEntityLeader entityLeader;
    @Nullable
    protected ICaptureAttributes villageAttributes;
    protected boolean attack;

    public BasicWerewolfEntity(EntityType<? extends BasicWerewolfEntity> type, World world, WerewolfForm werewolfForm) {
        super(type, world, true);
        this.werewolfForm = werewolfForm;
        this.entityClass = EntityClassType.getRandomClass((Random)world.field_73012_v);
        this.entityTier = EntityActionTier.Low;
        this.field_70728_aV = 3;
    }

    @Nonnull
    public EntitySize func_213305_a(@Nonnull Pose poseIn) {
        return this.werewolfForm.getSize(poseIn).map(p -> p.func_220313_a(this.func_213355_cm())).orElse(super.func_213305_a(poseIn));
    }

    public boolean func_104002_bU() {
        return super.func_104002_bU() || this.transformed != null;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.werewolfForm;
    }

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        return this;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        if (this.transformed == null) {
            return this;
        }
        ((MobEntity)this.transformed).func_82149_j((Entity)this);
        ((MobEntity)this.transformed).revive();
        this.field_70170_p.func_217376_c((Entity)((MobEntity)this.transformed));
        this.remove(false);
        ((MobEntity)this.transformed).func_70606_j(this.func_110143_aJ() / this.func_110138_aP() * ((MobEntity)this.transformed).func_110138_aP());
        return this.transformed;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityClass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entityTier;
    }

    @Override
    public int getSkinType(@Nonnull WerewolfForm form) {
        return Math.max(0, (Integer)this.func_184212_Q().func_187225_a(SKINTYPE));
    }

    @Override
    public int getEyeType(@Nonnull WerewolfForm form) {
        return Math.max(0, (Integer)this.func_184212_Q().func_187225_a(EYETYPE));
    }

    @Override
    public void start(WerewolfTransformable.TransformType type) {
        this.transformType = type;
        if (type == WerewolfTransformable.TransformType.TIME_LIMITED) {
            this.transformedDuration = (Integer)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_transform_duration.get();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.transformed != null && this.field_70170_p.func_82737_E() % 20L == 0L) {
            switch (this.transformType) {
                case TIME_LIMITED: {
                    if (--this.transformedDuration > 0) break;
                    this.transformBack();
                    break;
                }
                case FULL_MOON: {
                    if (Helper.isFullMoon(this.field_70170_p)) break;
                    this.transformBack();
                }
            }
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        Entity entity;
        ResourceLocation id;
        EntityType type;
        int t;
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("level")) {
            this.setLevel(nbt.func_74762_e("level"));
        }
        if (nbt.func_74764_b("type")) {
            t = nbt.func_74762_e("type");
            this.func_184212_Q().func_187227_b(SKINTYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.func_74764_b("eyeType")) {
            t = nbt.func_74762_e("eyeType");
            this.func_184212_Q().func_187227_b(EYETYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.func_74764_b("transformedDuration")) {
            this.transformedDuration = nbt.func_74762_e("transformedDuration");
        }
        if (nbt.func_74764_b("attack")) {
            this.attack = nbt.func_74767_n("attack");
        }
        if (nbt.func_74764_b("transformType")) {
            this.transformType = WerewolfTransformable.TransformType.valueOf(nbt.func_74779_i("transformType"));
        }
        if (nbt.func_74764_b("transformed") && (type = (EntityType)ForgeRegistries.ENTITIES.getValue(id = new ResourceLocation(nbt.func_74779_i("transformed_id")))) != null && (entity = type.func_200721_a(this.field_70170_p)) instanceof LivingEntity && entity instanceof WerewolfTransformable) {
            ((LivingEntity)entity).func_70037_a(nbt.func_74775_l("transformed"));
            this.transformed = (WerewolfTransformable)entity;
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("transformedDuration", this.transformedDuration);
        if (this.transformType != null) {
            nbt.func_74778_a("transformType", this.transformType.name());
        }
        nbt.func_74768_a("level", this.getLevel());
        nbt.func_74768_a("type", this.getSkinType());
        nbt.func_74768_a("eyeType", this.getEyeType());
        nbt.func_74757_a("attack", this.attack);
        if (this.transformed != null) {
            CompoundNBT transformed = new CompoundNBT();
            ((LivingEntity)this.transformed).func_189511_e(transformed);
            nbt.func_218657_a("transformed", (INBT)transformed);
            nbt.func_74778_a("transformed_id", ((LivingEntity)this.transformed).func_200600_R().getRegistryName().toString());
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.transformType == WerewolfTransformable.TransformType.TIME_LIMITED) {
            this.transformedDuration = (Integer)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_transform_duration.get() * 20;
        }
        return super.func_70097_a(source, amount);
    }

    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    @Override
    public boolean hasGlowingEyes(@Nonnull WerewolfForm form) {
        return true;
    }

    public void setLevel(int level) {
        if (level >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            if (level == 2) {
                this.func_195064_c(new EffectInstance(Effects.field_76429_m, 1000000, 1));
            }
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
    }

    @Nonnull
    protected ActionResultType func_230254_b_(@Nonnull PlayerEntity player, @Nonnull Hand hand) {
        int werewolfLevel = WerewolfPlayer.getOpt(player).map(VampirismPlayer::getLevel).orElse(0);
        if (werewolfLevel > 0) {
            FactionPlayerHandler.getOpt((PlayerEntity)player).ifPresent(fph -> {
                if (fph.getMaxMinions() > 0) {
                    ItemStack heldItem = player.func_184586_b(hand);
                    if (this.getLevel() > 0) {
                        if (heldItem.func_77973_b() == ModItems.WEREWOLF_MINION_CHARM.get()) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.basic_werewolf.minion.unavailable"), true);
                        }
                    } else {
                        boolean freeSlot = MinionWorldData.getData((World)player.field_70170_p).map(data -> data.getOrCreateController(fph)).map(PlayerMinionController::hasFreeMinionSlot).orElse(false);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.basic_werewolf.minion.available"), false);
                        if (heldItem.func_77973_b() == ModItems.WEREWOLF_MINION_CHARM.get()) {
                            if (!freeSlot) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.basic_werewolf.minion.no_free_slot"), false);
                            } else {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.basic_werewolf.minion.start_serving"), false);
                                this.convertToMinion(player);
                                if (!player.field_71075_bZ.field_75098_d) {
                                    heldItem.func_190918_g(1);
                                }
                            }
                        } else if (freeSlot) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.werewolves.basic_werewolf.minion.require_equipment", new Object[]{UtilLib.translate((String)((Item)ModItems.WEREWOLF_MINION_CHARM.get()).func_77658_a(), (Object[])new Object[0])}), false);
                        }
                    }
                }
            });
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void convertToMinion(PlayerEntity lord) {
        FactionPlayerHandler.getOpt((PlayerEntity)lord).ifPresent(fph -> {
            if (fph.getMaxMinions() > 0) {
                MinionWorldData.getData((World)lord.field_70170_p).map(w -> w.getOrCreateController(fph)).ifPresent(controller -> {
                    if (controller.hasFreeMinionSlot()) {
                        if (fph.getCurrentFaction() == this.getFaction()) {
                            WerewolfMinionEntity.WerewolfMinionData data = new WerewolfMinionEntity.WerewolfMinionData("Minion", this.getSkinType(), this.getEyeType(), this.hasGlowingEyes(), this.getForm());
                            int id = controller.createNewMinionSlot((MinionData)data, (EntityType)ModEntities.WEREWOLF_MINION.get());
                            if (id < 0) {
                                field_184243_a.error("Failed to get minion slot");
                                return;
                            }
                            ModEntities.WEREWOLF_MINION.map(a -> (WerewolfMinionEntity)a.func_200721_a(this.field_70170_p)).ifPresent(minion -> {
                                minion.claimMinionSlot(id, controller);
                                minion.func_82149_j((Entity)this);
                                minion.markAsConverted();
                                controller.activateTask(0, (IMinionTask)MinionTasks.STAY.get());
                                UtilLib.replaceEntity((LivingEntity)this, (LivingEntity)minion);
                            });
                        } else {
                            field_184243_a.warn("Wrong faction for minion");
                        }
                    } else {
                        field_184243_a.warn("No free slot");
                    }
                });
            } else {
                field_184243_a.error("Can't have minions");
            }
        });
    }

    public int getMaxLevel() {
        return 2;
    }

    @Override
    public boolean canTransform() {
        return this.transformed != null;
    }

    public int suggestLevel(de.teamlapen.vampirism.api.difficulty.Difficulty difficulty) {
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                return (int)((float)difficulty.minPercLevel / 100.0f * 2.0f);
            }
            case 1: {
                return (int)((float)difficulty.avgPercLevel / 100.0f * 2.0f);
            }
            case 2: {
                return (int)((float)difficulty.maxPercLevel / 100.0f * 2.0f);
            }
        }
        return this.field_70146_Z.nextInt(3);
    }

    protected void updateEntityAttributes() {
        int l = Math.max(this.getLevel(), 0);
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health.get() + (Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health_pl.get() * (double)l);
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage.get() + (Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage_pl.get() * (double)l);
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_speed.get()).doubleValue());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.func_184212_Q().func_187225_a(SKINTYPE) == -1) {
            this.func_184212_Q().func_187227_b(SKINTYPE, (Object)this.func_70681_au().nextInt(126));
        }
        if ((Integer)this.func_184212_Q().func_187225_a(EYETYPE) == -1) {
            this.func_184212_Q().func_187227_b(EYETYPE, (Object)this.func_70681_au().nextInt(126));
        }
    }

    public void setSourceEntity(WerewolfTransformable entity) {
        this.entityClass = entity.getEntityClass();
        this.entityTier = entity.getEntityTier();
        this.transformed = entity;
    }

    public void attackVillage(ICaptureAttributes iCaptureAttributes) {
        this.villageAttributes = iCaptureAttributes;
        this.attack = true;
    }

    public void defendVillage(ICaptureAttributes iCaptureAttributes) {
        this.villageAttributes = iCaptureAttributes;
        this.attack = false;
    }

    @Nullable
    public AxisAlignedBB getTargetVillageArea() {
        return this.villageAttributes == null ? null : this.villageAttributes.getVillageArea();
    }

    public int func_70627_aG() {
        return 240;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.ENTITY_WEREWOLF_GROWL.get();
    }

    @Nullable
    public ICaptureAttributes getCaptureInfo() {
        return this.villageAttributes;
    }

    public boolean isDefendingVillage() {
        return this.villageAttributes != null && !this.attack;
    }

    public boolean isAttackingVillage() {
        return this.villageAttributes != null && this.attack;
    }

    public void stopVillageAttackDefense() {
        this.villageAttributes = null;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreakDoorGoal((MobEntity)this, difficulty -> difficulty == Difficulty.HARD));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, new FollowAlphaWerewolfGoal<BasicWerewolfEntity>(this, 0.8));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, HunterBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new WerewolfAttackVillageGoal<BasicWerewolfEntity>(this));
        this.field_70715_bh.func_75776_a(4, new WerewolfDefendVillageGoal<BasicWerewolfEntity>(this));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, false, true, true, null)));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PatrollerEntity.class, 5, true, true, living -> UtilLib.isInsideStructure((Entity)living, (Structure)Structure.field_236381_q_)));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
        this.field_70715_bh.func_75776_a(8, new DefendLeaderGoal<BasicWerewolfEntity>(this));
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof LivingEntity) {
                this.bite((LivingEntity)entity);
            }
            return true;
        }
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
        this.func_184212_Q().func_187214_a(SKINTYPE, (Object)-1);
        this.func_184212_Q().func_187214_a(EYETYPE, (Object)-1);
    }

    @Override
    @Nonnull
    public Optional<IEntityLeader> getLeader() {
        return Optional.ofNullable(this.entityLeader);
    }

    @Override
    public void setLeader(@Nullable IEntityLeader leader) {
        this.entityLeader = leader;
    }

    public static class Survivalist
    extends BasicWerewolfEntity {
        public Survivalist(EntityType<? extends Survivalist> type, World world) {
            super(type, world, WerewolfForm.SURVIVALIST);
        }
    }

    public static class Beast
    extends BasicWerewolfEntity {
        public Beast(EntityType<? extends Beast> type, World world) {
            super(type, world, WerewolfForm.BEAST);
        }

        public void func_70645_a(@Nonnull DamageSource cause) {
            if (this.villageAttributes == null) {
                BadOmenEffect.handlePotentialBannerKill((Entity)cause.func_76346_g(), (IFactionEntity)this);
            }
            super.func_70645_a(cause);
        }

        @Nullable
        public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT nbt) {
            if (reason != SpawnReason.SPAWN_EGG && reason != SpawnReason.BUCKET && reason != SpawnReason.CONVERSION && reason != SpawnReason.COMMAND && this.func_70681_au().nextInt(50) == 0) {
                this.func_184201_a(EquipmentSlotType.HEAD, WerewolfVillageData.createBanner());
            }
            return super.func_213386_a(world, difficulty, reason, spawnData, nbt);
        }
    }
}

