/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HumanWerewolfEntity
extends CreatureEntity
implements WerewolfTransformable {
    private static final DataParameter<Integer> FORM = EntityDataManager.func_187226_a(HumanWerewolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(HumanWerewolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> EYE_TYPE = EntityDataManager.func_187226_a(HumanWerewolfEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> GLOWING_EYES = EntityDataManager.func_187226_a(HumanWerewolfEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final EntityClassType classType = EntityClassType.getRandomClass((Random)this.func_70681_au());
    private final EntityActionTier actionTier = EntityActionTier.Medium;
    protected int rage;

    public HumanWerewolfEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static boolean spawnPredicateHumanWerewolf(EntityType<? extends CreatureEntity> entityType, IServerWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        if (world.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        if (spawnReason == SpawnReason.EVENT) {
            return true;
        }
        if (!MonsterEntity.func_223323_a((IServerWorld)world, (BlockPos)blockPos, (Random)random) && !FormHelper.isInWerewolfBiome((IWorld)world, blockPos)) {
            return false;
        }
        return MobEntity.func_223315_a(entityType, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)random);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FORM, (Object)-1);
        this.func_184212_Q().func_187214_a(SKIN_TYPE, (Object)-1);
        this.func_184212_Q().func_187214_a(EYE_TYPE, (Object)-1);
        this.func_184212_Q().func_187214_a(GLOWING_EYES, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(9, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 20.0f, 0.6f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, HunterBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, VampireBaseEntity.class, 17.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            this.rage = (int)((float)this.rage + amount * 10.0f);
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.rage > 150) {
            WerewolfTransformable werewolf = this.transformToWerewolf(WerewolfTransformable.TransformType.TIME_LIMITED);
            ((MobEntity)werewolf).func_70604_c(this.func_70638_az());
        }
        if (this.field_70170_p.func_82737_E() % 400L == 10L) {
            if (Helper.isFullMoon(this.field_70170_p)) {
                this.transformToWerewolf(WerewolfTransformable.TransformType.FULL_MOON);
            }
            this.rage -= 2;
        }
    }

    @Override
    public void reset() {
        this.rage = 0;
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        return CreatureEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, ((Double)WerewolvesConfig.BALANCE.MOBPROPS.human_werewolf_speed.get()).doubleValue()).func_233815_a_(Attributes.field_233819_b_, 48.0).func_233815_a_(Attributes.field_233823_f_, ((Double)WerewolvesConfig.BALANCE.MOBPROPS.human_werewolf_attack_damage.get()).doubleValue()).func_233815_a_(Attributes.field_233818_a_, ((Double)WerewolvesConfig.BALANCE.MOBPROPS.human_werewolf_max_health.get()).doubleValue());
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        int t;
        super.func_70037_a(compound);
        if (compound.func_74764_b("form")) {
            t = compound.func_74762_e("form");
            this.func_184212_Q().func_187227_b(FORM, (Object)(t < 2 && t >= 0 ? t : -1));
        }
        if (compound.func_74764_b("type")) {
            t = compound.func_74762_e("type");
            this.func_184212_Q().func_187227_b(SKIN_TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (compound.func_74764_b("eye_type")) {
            t = compound.func_74762_e("eye_type");
            this.func_184212_Q().func_187227_b(EYE_TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (compound.func_74764_b("glowing_eye")) {
            this.func_184212_Q().func_187227_b(GLOWING_EYES, (Object)compound.func_74767_n("glowing_eye"));
        }
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("form", ((Integer)this.func_184212_Q().func_187225_a(FORM)).intValue());
        compound.func_74768_a("type", ((Integer)this.func_184212_Q().func_187225_a(SKIN_TYPE)).intValue());
        compound.func_74768_a("eye_type", ((Integer)this.func_184212_Q().func_187225_a(EYE_TYPE)).intValue());
        compound.func_74757_a("glowing_eye", ((Boolean)this.func_184212_Q().func_187225_a(GLOWING_EYES)).booleanValue());
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.func_184212_Q().func_187225_a(FORM) == -1) {
            this.func_184212_Q().func_187227_b(FORM, (Object)this.func_70681_au().nextInt(2));
        }
        if ((Integer)this.func_184212_Q().func_187225_a(SKIN_TYPE) == -1) {
            this.func_184212_Q().func_187227_b(SKIN_TYPE, (Object)this.func_70681_au().nextInt(126));
        }
        if ((Integer)this.func_184212_Q().func_187225_a(EYE_TYPE) == -1) {
            this.func_184212_Q().func_187227_b(EYE_TYPE, (Object)this.func_70681_au().nextInt(126));
        }
        this.func_184212_Q().func_187227_b(GLOWING_EYES, (Object)this.func_70681_au().nextBoolean());
    }

    @Override
    public int getSkinType(@Nonnull WerewolfForm form) {
        int i = (Integer)this.func_184212_Q().func_187225_a(SKIN_TYPE);
        return Math.max(i, 0);
    }

    @Override
    public int getEyeType(@Nonnull WerewolfForm form) {
        int i = (Integer)this.func_184212_Q().func_187225_a(EYE_TYPE);
        return Math.max(i, 0);
    }

    @Override
    public boolean hasGlowingEyes(@Nonnull WerewolfForm form) {
        return (Boolean)this.func_184212_Q().func_187225_a(GLOWING_EYES);
    }

    @Override
    public WerewolfTransformable _transformToWerewolf() {
        EntityType type;
        switch ((Integer)this.func_184212_Q().func_187225_a(FORM)) {
            case 0: {
                type = (EntityType)ModEntities.WEREWOLF_BEAST.get();
                break;
            }
            case 2: {
                type = (EntityType)ModEntities.WEREWOLF_SURVIVALIST.get();
                break;
            }
            default: {
                return this;
            }
        }
        BasicWerewolfEntity werewolf = (BasicWerewolfEntity)WerewolfTransformable.copyData(type, (MobEntity)this);
        werewolf.setSourceEntity(this);
        return werewolf;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.actionTier;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.classType;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        return this;
    }

    @Override
    public boolean canTransform() {
        return !this.field_70170_p.field_72995_K && Helper.isNight(this.field_70170_p) && this.rage > 0;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        switch ((Integer)this.func_184212_Q().func_187225_a(FORM)) {
            case 0: {
                return WerewolfForm.BEAST;
            }
            case 1: {
                return WerewolfForm.SURVIVALIST;
            }
        }
        return WerewolfForm.NONE;
    }
}

