/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.Difficulty;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.goals.LookAtClosestVisibleGoal;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.core.ModSounds;
import de.teamlapen.werewolves.entities.werewolf.IWerewolfAlpha;
import de.teamlapen.werewolves.entities.werewolf.WerewolfBaseEntity;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WerewolfAlphaEntity
extends WerewolfBaseEntity
implements IWerewolfAlpha {
    public static final int MAX_LEVEL = 4;
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(WerewolfAlphaEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int followingEntities = 0;

    public static boolean spawnPredicateAlpha(EntityType<? extends WerewolfAlphaEntity> entityType, IServerWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return ModBiomes.WEREWOLF_HEAVEN_KEY.func_240901_a_().equals((Object)Helper.getBiomeId((IBiomeReader)world, (BlockPos)blockPos)) && world.func_175659_aa() != net.minecraft.world.Difficulty.PEACEFUL && WerewolfAlphaEntity.spawnPredicateWerewolf(entityType, world, spawnReason, blockPos, random);
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        AttributeModifierMap.MutableAttribute mutableAttribute = VampireBaseEntity.getAttributeBuilder();
        BalanceMobProps.mobProps.getClass();
        AttributeModifierMap.MutableAttribute mutableAttribute2 = mutableAttribute.func_233815_a_(Attributes.field_233818_a_, 140.0);
        BalanceMobProps.mobProps.getClass();
        AttributeModifierMap.MutableAttribute mutableAttribute3 = mutableAttribute2.func_233815_a_(Attributes.field_233823_f_, 6.0);
        BalanceMobProps.mobProps.getClass();
        return mutableAttribute3.func_233815_a_(Attributes.field_233821_d_, 0.34).func_233815_a_(Attributes.field_233819_b_, 5.0);
    }

    public WerewolfAlphaEntity(EntityType<? extends VampirismEntity> type, World world) {
        super(type, world, true);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("level", this.getLevel());
    }

    public void decreaseFollowerCount() {
        this.followingEntities = Math.max(0, this.followingEntities - 1);
    }

    public int getFollowingCount() {
        return this.followingEntities;
    }

    public void setLevel(int level) {
        if ((level = MathHelper.func_76125_a((int)level, (int)0, (int)4)) >= 0) {
            this.func_184212_Q().func_187227_b(LEVEL, (Object)level);
            this.updateEntityAttributes();
            this.func_200203_b((ITextComponent)this.func_225513_by_().func_230531_f_().func_230529_a_((ITextComponent)new TranslationTextComponent("entity.werewolves.alpha_werewolf.level", new Object[]{level + 1})));
        } else {
            this.func_200203_b(null);
        }
    }

    public int getLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(LEVEL);
    }

    public int getMaxLevel() {
        return 4;
    }

    public int func_70646_bf() {
        return 5;
    }

    public int func_184649_cE() {
        return 5;
    }

    public int getMaxFollowerCount() {
        BalanceMobProps.mobProps.getClass();
        return (int)(5.0f * ((float)(this.getLevel() + 1) / (float)(this.getMaxLevel() + 1)));
    }

    public int func_82145_z() {
        return 500;
    }

    public boolean increaseFollowerCount() {
        if (this.followingEntities < this.getMaxFollowerCount()) {
            ++this.followingEntities;
            return true;
        }
        return false;
    }

    public void func_241847_a(ServerWorld p_241847_1_, LivingEntity p_241847_2_) {
        super.func_241847_a(p_241847_1_, p_241847_2_);
        if (p_241847_2_ instanceof WerewolfAlphaEntity) {
            this.func_70606_j(this.func_110138_aP());
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setLevel(nbt.func_74762_e("level"));
    }

    public boolean func_94059_bO() {
        return true;
    }

    public int func_70627_aG() {
        return 240;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.ENTITY_WEREWOLF_GROWL.get();
    }

    public int suggestLevel(Difficulty d) {
        int avg = Math.round(((float)d.avgPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int max = Math.round(((float)d.maxPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        int min = Math.round(((float)d.minPercLevel / 100.0f - 0.35714287f) / 0.64285713f * 4.0f);
        switch (this.field_70146_Z.nextInt(7)) {
            case 0: {
                return min;
            }
            case 1: {
                return max + 1;
            }
            case 2: {
                return avg;
            }
            case 3: {
                return avg + 1;
            }
            case 4: 
            case 5: {
                return this.field_70146_Z.nextInt(5);
            }
        }
        return this.field_70146_Z.nextInt(max + 2 - min) + min;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(LEVEL, (Object)-1);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 20 + 5 * this.getLevel();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 6.0f, 0.6, (double)0.7f, input -> input != null && !this.isLowerLevel((LivingEntity)input)));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.2));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtClosestVisibleGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, this::isLowerLevel));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WerewolfAlphaEntity.class, true, false));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 5, true, false, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), false, true, false, false, null)));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
    }

    private boolean isLowerLevel(LivingEntity player) {
        if (player instanceof PlayerEntity) {
            int playerLevel = FactionPlayerHandler.getOpt((PlayerEntity)((PlayerEntity)player)).map(FactionPlayerHandler::getCurrentLevel).orElse(0);
            return (float)(playerLevel - 8) / 2.0f - (float)this.getLevel() <= 0.0f;
        }
        return false;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return WerewolfForm.BEAST4L;
    }

    @Override
    public int getSkinType(@Nonnull WerewolfForm form) {
        return 0;
    }

    @Override
    public int getEyeType(@Nonnull WerewolfForm form) {
        return 0;
    }

    @Override
    public boolean hasGlowingEyes(@Nonnull WerewolfForm form) {
        return true;
    }

    protected void updateEntityAttributes() {
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a(20.0);
        ModifiableAttributeInstance modifiableAttributeInstance = this.func_110148_a(Attributes.field_233821_d_);
        BalanceMobProps.mobProps.getClass();
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance.func_111128_a(0.34 * Math.pow((1.2 - 1.0) / 5.0 + 1.0, this.getLevel()));
        ModifiableAttributeInstance modifiableAttributeInstance2 = this.func_110148_a(Attributes.field_233818_a_);
        BalanceMobProps.mobProps.getClass();
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance2.func_111128_a(140.0 * Math.pow(1.2, this.getLevel()));
        ModifiableAttributeInstance modifiableAttributeInstance3 = this.func_110148_a(Attributes.field_233823_f_);
        BalanceMobProps.mobProps.getClass();
        BalanceMobProps.mobProps.getClass();
        modifiableAttributeInstance3.func_111128_a(6.0 * Math.pow(1.2, this.getLevel()));
    }
}

