/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.entities.werewolf;

import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.effects.LupusSanguinemEffect;
import de.teamlapen.werewolves.entities.werewolf.IWerewolfMob;
import de.teamlapen.werewolves.util.FormHelper;
import de.teamlapen.werewolves.util.WReference;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class WerewolfBaseEntity
extends VampirismEntity
implements IWerewolfMob {
    private final boolean countAsMonsterForSpawn;

    public WerewolfBaseEntity(EntityType<? extends VampirismEntity> type, World world, boolean countAsMonsterForSpawn) {
        super(type, world);
        this.countAsMonsterForSpawn = countAsMonsterForSpawn;
    }

    public static boolean spawnPredicateWerewolf(EntityType<? extends WerewolfBaseEntity> entityType, IServerWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        if (world.func_175659_aa() == Difficulty.PEACEFUL) {
            return false;
        }
        if (spawnReason == SpawnReason.EVENT) {
            return true;
        }
        if (!MonsterEntity.func_223323_a((IServerWorld)world, (BlockPos)blockPos, (Random)random) && !FormHelper.isInWerewolfBiome((IWorld)world, blockPos)) {
            return false;
        }
        return MobEntity.func_223315_a(entityType, (IWorld)world, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)random);
    }

    public void bite(LivingEntity entity) {
        LupusSanguinemEffect.addSanguinemEffectRandom(entity, 0.05f);
    }

    public EntityClassification getClassification(boolean forSpawnCount) {
        return forSpawnCount && this.countAsMonsterForSpawn ? EntityClassification.MONSTER : super.getClassification(forSpawnCount);
    }

    public IFaction<?> getFaction() {
        return WReference.WEREWOLF_FACTION;
    }

    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public static AttributeModifierMap.MutableAttribute getAttributeBuilder() {
        return VampirismEntity.getAttributeBuilder().func_233815_a_(Attributes.field_233818_a_, ((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_max_health.get()).doubleValue()).func_233815_a_(Attributes.field_233823_f_, ((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_attack_damage.get()).doubleValue()).func_233815_a_(Attributes.field_233821_d_, ((Double)WerewolvesConfig.BALANCE.MOBPROPS.werewolf_speed.get()).doubleValue());
    }
}

