/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.inventory.recipes;

import com.mojang.datafixers.util.Either;
import de.teamlapen.werewolves.util.Helper;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class TagNBTBrewingRecipe
implements IBrewingRecipe {
    private final Ingredient input;
    private final Either<ITag<Item>, Ingredient> ingredient;
    private final ItemStack output;

    public TagNBTBrewingRecipe(Ingredient input, ITag<Item> ingredient, ItemStack output) {
        this.input = input;
        this.ingredient = Either.left(ingredient);
        this.output = output;
    }

    public TagNBTBrewingRecipe(Ingredient input, Ingredient ingredient, ItemStack output) {
        this.input = input;
        this.ingredient = Either.right((Object)ingredient);
        this.output = output;
    }

    public boolean isInput(@Nonnull ItemStack input) {
        return Helper.matchesItem(this.input, input);
    }

    public boolean isIngredient(@Nonnull ItemStack ingredient) {
        return (Boolean)this.ingredient.map(i -> i.func_230235_a_((Object)ingredient.func_77973_b()), i -> i.test(ingredient));
    }

    @Nonnull
    public ItemStack getOutput(@Nonnull ItemStack input, @Nonnull ItemStack ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? this.output.func_77946_l() : ItemStack.field_190927_a;
    }

    public ItemStack[] getIngredient() {
        return (ItemStack[])this.ingredient.map(i -> (ItemStack[])i.func_230236_b_().stream().map(ItemStack::new).toArray(ItemStack[]::new), Ingredient::func_193365_a);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }
}

