/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.items.oil;

import de.teamlapen.vampirism.api.items.oil.IWeaponOil;
import de.teamlapen.vampirism.items.VampirismVampireSword;
import de.teamlapen.vampirism.items.oil.WeaponOil;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModOils;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.items.ISilverItem;
import de.teamlapen.werewolves.util.Helper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SilverOil
extends WeaponOil {
    public SilverOil(int color, int maxDuration) {
        super(color, maxDuration);
    }

    public float onDamage(ItemStack stack, float amount, IWeaponOil oil, LivingEntity target, LivingEntity source) {
        return Helper.isWerewolf((Entity)target) ? amount * this.getDamageModifier() : 0.0f;
    }

    public boolean canBeApplied(ItemStack stack) {
        return super.canBeApplied(stack) && !(stack.func_77973_b() instanceof ISilverItem) && !ModTags.Items.SILVER_TOOL.func_230235_a_((Object)stack.func_77973_b()) && !(stack.func_77973_b() instanceof VampirismVampireSword);
    }

    public float getDamageModifier() {
        return this == ModOils.SILVER_OIL_2.get() ? 0.25f : 0.125f;
    }

    public int getMaxDuration(ItemStack stack) {
        return this == ModOils.SILVER_OIL_2.get() ? ((Integer)WerewolvesConfig.BALANCE.OILS.silverOil2Duration.get()).intValue() : ((Integer)WerewolvesConfig.BALANCE.OILS.silverOil1Duration.get()).intValue();
    }

    public void getDescription(ItemStack stack, List<ITextComponent> tooltips) {
        super.getDescription(stack, tooltips);
        tooltips.add((ITextComponent)new TranslationTextComponent("text.werewolves.oil.when_applied").func_240699_a_(TextFormatting.GRAY));
        tooltips.add((ITextComponent)new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("text.werewolves.oil.silver.more_damage", new Object[]{Float.valueOf(this.getDamageModifier() * 100.0f)}).func_240699_a_(TextFormatting.DARK_GREEN)));
    }
}

