/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.mixin.entity;

import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.werewolves.core.ModEntities;
import de.teamlapen.werewolves.entities.werewolf.BasicWerewolfEntity;
import de.teamlapen.werewolves.entities.werewolf.IVillagerTransformable;
import de.teamlapen.werewolves.entities.werewolf.WerewolfTransformable;
import de.teamlapen.werewolves.util.Helper;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={VillagerEntity.class})
public abstract class MixinVillagerEntity
extends AbstractVillagerEntity
implements IVillagerTransformable {
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(VillagerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private boolean werewolf;
    private WerewolfForm form = WerewolfForm.BEAST;
    private final EntityActionTier entityTier = EntityActionTier.Medium;
    private EntityClassType entityClass;
    protected int rage;

    @Deprecated
    public MixinVillagerEntity(EntityType<? extends AbstractVillagerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public BasicWerewolfEntity _transformToWerewolf() {
        EntityType type = this.form == WerewolfForm.BEAST ? (EntityType)ModEntities.WEREWOLF_BEAST.get() : (EntityType)ModEntities.WEREWOLF_SURVIVALIST.get();
        BasicWerewolfEntity entity = (BasicWerewolfEntity)WerewolfTransformable.copyData(type, (MobEntity)this);
        entity.setSourceEntity(this);
        return entity;
    }

    @Override
    public WerewolfTransformable _transformBack() {
        return this;
    }

    @Override
    public boolean canTransform() {
        return this.isWerewolf() && (float)this.rage > this.func_110138_aP() * 4.0f;
    }

    private boolean isWerewolf() {
        return this.werewolf && !(this instanceof IVampire) && ExtendedCreature.getSafe((Entity)this).map(IExtendedCreatureVampirism::hasPoisonousBlood).orElse(false) == false;
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (this.isWerewolf()) {
                this.rage = (int)((float)this.rage + amount * 10.0f);
            }
            return true;
        }
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isWerewolf()) {
            if (this.rage > 150) {
                WerewolfTransformable werewolf = this.transformToWerewolf(WerewolfTransformable.TransformType.TIME_LIMITED);
                ((MobEntity)werewolf).func_70604_c(this.func_70638_az());
            }
            if (this.field_70170_p.func_82737_E() % 400L == 10L) {
                if (Helper.isFullMoon(this.field_70170_p)) {
                    this.transformToWerewolf(WerewolfTransformable.TransformType.FULL_MOON);
                }
                if (this.rage > 10) {
                    this.rage -= 10;
                }
            }
        }
    }

    @Override
    public void reset() {
        this.rage = 0;
    }

    @Override
    @Nonnull
    public WerewolfForm getForm() {
        return this.form;
    }

    @Override
    public EntityClassType getEntityClass() {
        return this.entityClass == null ? (this.entityClass = EntityClassType.getRandomClass((Random)this.func_70681_au())) : this.entityClass;
    }

    @Override
    public EntityActionTier getEntityTier() {
        return this.entityTier;
    }

    @Override
    public int getSkinType(WerewolfForm form) {
        int i = (Integer)this.func_184212_Q().func_187225_a(TYPE);
        return Math.max(i, 0);
    }

    @Override
    public void setWerewolfFaction(boolean werewolf) {
        this.werewolf = werewolf;
        if (werewolf) {
            this.form = this.func_70681_au().nextBoolean() ? WerewolfForm.SURVIVALIST : WerewolfForm.BEAST;
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if ((Integer)this.func_184212_Q().func_187225_a(TYPE) == -1) {
            this.func_184212_Q().func_187227_b(TYPE, (Object)this.func_70681_au().nextInt(126));
        }
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="RETURN")})
    protected void werewolves_defineSynchedData(CallbackInfo ci) {
        this.func_184212_Q().func_187214_a(TYPE, (Object)-1);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    public void werewolves_addAdditionalSaveData(CompoundNBT compound, CallbackInfo ci) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("werewolf", this.werewolf);
        if (this.form != null) {
            nbt.func_74778_a("form", this.form.getName());
        }
        nbt.func_74768_a("type", this.getSkinType());
        if (this.entityClass != null) {
            nbt.func_74768_a("entityclasstype", EntityClassType.getID((EntityClassType)this.entityClass));
        }
        compound.func_218657_a("werewolves", (INBT)nbt);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    public void werewolves_readAdditionalSaveData(CompoundNBT compound, CallbackInfo ci) {
        CompoundNBT nbt = compound.func_74775_l("werewolves");
        this.werewolf = nbt.func_74767_n("werewolf");
        if (nbt.func_74764_b("form")) {
            this.form = WerewolfForm.getForm(nbt.func_74779_i("form"));
        }
        if (nbt.func_74764_b("type")) {
            int t = nbt.func_74762_e("type");
            this.func_184212_Q().func_187227_b(TYPE, (Object)(t < 126 && t >= 0 ? t : -1));
        }
        if (nbt.func_74764_b("entityclasstype")) {
            this.entityClass = EntityClassType.getEntityClassType((int)nbt.func_74762_e("entityclasstype"));
        }
    }
}

