/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.werewolves.core.ModActions;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InputEventPacket
implements IMessage {
    public static final String BITE = "bt";
    public static final String LEAP = "lp";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SPLIT = "&";
    private String param;
    private String action;

    public InputEventPacket(String action, String param) {
        this.action = action;
        this.param = param;
    }

    private InputEventPacket() {
    }

    static void encode(InputEventPacket msg, PacketBuffer buf) {
        buf.func_180714_a(msg.action + SPLIT + msg.param);
    }

    static InputEventPacket decode(PacketBuffer buf) {
        String[] s = buf.func_150789_c(50).split(SPLIT);
        InputEventPacket msg = new InputEventPacket();
        msg.action = s[0];
        msg.param = s.length > 1 ? s[1] : "";
        return msg;
    }

    public static void handle(InputEventPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        Validate.notNull((Object)msg.action);
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            if (BITE.equals(msg.action)) {
                try {
                    int id = Integer.parseInt(msg.param);
                    if (id != 0) {
                        WerewolfPlayer.getOpt((PlayerEntity)player).ifPresent(werewolfPlayer -> werewolfPlayer.bite(id));
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Receiving invalid param {} for {}", (Object)msg.param, (Object)msg.action);
                }
            } else if (LEAP.equals(msg.action)) {
                WerewolfPlayer.getOpt((PlayerEntity)player).ifPresent(werewolfPlayer -> werewolfPlayer.getActionHandler().toggleAction((IAction)ModActions.LEAP.get()));
            }
            ctx.setPacketHandled(true);
        });
    }
}

