/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.network;

import de.teamlapen.lib.network.IMessage;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class WerewolfAppearancePacket
implements IMessage {
    public final int entityId;
    public final String name;
    public final WerewolfForm form;
    public final int[] data;

    static void encode(WerewolfAppearancePacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.entityId);
        buf.func_180714_a(msg.name);
        buf.func_180714_a(msg.form.getName());
        buf.func_150787_b(msg.data.length);
        for (int value : msg.data) {
            buf.func_150787_b(value);
        }
    }

    static WerewolfAppearancePacket decode(PacketBuffer buf) {
        int entityId = buf.func_150792_a();
        String newName = buf.func_150789_c(15);
        String form = buf.func_150789_c(Short.MAX_VALUE);
        int[] data = new int[buf.func_150792_a()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = buf.func_150792_a();
        }
        return new WerewolfAppearancePacket(entityId, newName, WerewolfForm.getForm(form), data);
    }

    public static void handle(WerewolfAppearancePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> WerewolvesMod.proxy.handleAppearancePacket(ctx.getSender(), msg));
        ctx.setPacketHandled(true);
    }

    public WerewolfAppearancePacket(int entityId, String name, WerewolfForm form, int ... data) {
        this.entityId = entityId;
        this.name = name;
        this.form = form;
        this.data = data;
    }
}

