/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.proxy;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.werewolves.client.core.ClientEventHandler;
import de.teamlapen.werewolves.client.core.ModBlocksRenderer;
import de.teamlapen.werewolves.client.core.ModEntityRenderer;
import de.teamlapen.werewolves.client.core.ModHUDOverlay;
import de.teamlapen.werewolves.client.core.ModItemRenderer;
import de.teamlapen.werewolves.client.core.ModKeys;
import de.teamlapen.werewolves.client.core.ModScreens;
import de.teamlapen.werewolves.client.core.RenderHandler;
import de.teamlapen.werewolves.network.AttackTargetEventPacket;
import de.teamlapen.werewolves.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    private ModHUDOverlay hudOverlay;
    private ClientEventHandler clientHandler;
    private boolean autoJump;

    public ClientProxy() {
        RenderHandler renderHandler = new RenderHandler(Minecraft.func_71410_x());
        MinecraftForge.EVENT_BUS.register((Object)renderHandler);
        if (Minecraft.func_71410_x() != null) {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)renderHandler);
        }
    }

    @Override
    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        super.onInitStep(step, event);
        switch (step) {
            case CLIENT_SETUP: {
                ModEntityRenderer.registerEntityRenderer();
                ModBlocksRenderer.register();
                this.clientHandler = new ClientEventHandler();
                MinecraftForge.EVENT_BUS.register((Object)this.clientHandler);
                this.hudOverlay = new ModHUDOverlay();
                MinecraftForge.EVENT_BUS.register((Object)this.hudOverlay);
                ModKeys.register(this.clientHandler);
                break;
            }
            case LOAD_COMPLETE: {
                event.enqueueWork(ModItemRenderer::registerColorsUnsafe);
                event.enqueueWork(ModScreens::registerScreensUnsafe);
            }
        }
    }

    @Override
    public void handleAttackTargetEventPacket(AttackTargetEventPacket packet) {
        this.hudOverlay.attackTriggered(packet.entityId);
    }
}

