/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.util;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBiomes;
import de.teamlapen.werewolves.entities.player.werewolf.IWerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.player.werewolf.actions.WerewolfFormAction;
import de.teamlapen.werewolves.entities.werewolf.IWerewolfDataholder;
import de.teamlapen.werewolves.util.WerewolfForm;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;

public class FormHelper {
    private static final Set<ResourceLocation> noWerewolfFormTickingBiomes = new HashSet<ResourceLocation>();

    public static void reload() {
        noWerewolfFormTickingBiomes.clear();
        List biomes = (List)WerewolvesConfig.SERVER.werewolfFormFreeFormBiomes.get();
        for (String s : biomes) {
            ResourceLocation id = new ResourceLocation(s);
            noWerewolfFormTickingBiomes.add(id);
        }
        noWerewolfFormTickingBiomes.add(ModBiomes.WEREWOLF_HEAVEN_KEY.func_240901_a_());
    }

    public static boolean isInWerewolfBiome(IWorld world, BlockPos pos) {
        Biome biome = world.func_226691_t_(pos);
        return world.func_241828_r().func_230521_a_(Registry.field_239720_u_).map(registry -> registry.func_177774_c((Object)biome)).map(noWerewolfFormTickingBiomes::contains).orElse(false);
    }

    public static WerewolfForm getForm(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return WerewolfPlayer.getOpt((PlayerEntity)entity).map(WerewolfPlayer::getForm).orElse(WerewolfForm.NONE);
        }
        if (entity instanceof IWerewolfDataholder) {
            return ((IWerewolfDataholder)entity).getForm();
        }
        return WerewolfForm.NONE;
    }

    public static boolean isFormActionActive(IWerewolfPlayer player) {
        return WerewolfFormAction.isWerewolfFormActionActive((IActionHandler<IWerewolfPlayer>)player.getActionHandler());
    }

    public static Optional<WerewolfFormAction> getActiveFormAction(IWerewolfPlayer werewolf) {
        return WerewolfFormAction.getAllAction().stream().filter(action -> werewolf.getActionHandler().isActionActive((ILastingAction)action)).findAny();
    }

    public static void deactivateWerewolfActions(IWerewolfPlayer player) {
        WerewolfFormAction.getAllAction().stream().filter(action -> player.getActionHandler().isActionActive((ILastingAction)action)).forEach(action -> player.getActionHandler().toggleAction((IAction)action));
    }
}

