/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.util;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModTags;
import de.teamlapen.werewolves.core.WerewolfSkills;
import de.teamlapen.werewolves.entities.player.werewolf.WerewolfPlayer;
import de.teamlapen.werewolves.entities.werewolf.IWerewolf;
import de.teamlapen.werewolves.util.BiteDamageSource;
import de.teamlapen.werewolves.util.WReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class Helper
extends de.teamlapen.vampirism.util.Helper {
    public static boolean isWerewolf(Entity entity) {
        return WReference.WEREWOLF_FACTION.equals((Object)VampirismAPI.factionRegistry().getFaction(entity));
    }

    public static boolean isWerewolf(PlayerEntity entity) {
        return VampirismAPI.getFactionPlayerHandler((PlayerEntity)entity).map(h -> WReference.WEREWOLF_FACTION.equals((Object)h.getCurrentFaction())).orElse(false);
    }

    public static boolean hasFaction(Entity entity) {
        if (VampirismAPI.factionRegistry().getFaction(entity) != null) {
            return true;
        }
        return Helper.isWerewolf(entity);
    }

    public static BlockPos multiplyBlockPos(BlockPos pos, double amount) {
        return new BlockPos((double)pos.func_177958_n() * amount, (double)pos.func_177956_o() * amount, (double)pos.func_177952_p() * amount);
    }

    public static boolean canBecomeWerewolf(PlayerEntity player) {
        return FactionPlayerHandler.getOpt((PlayerEntity)player).map(v -> v.canJoin(WReference.WEREWOLF_FACTION)).orElse(false);
    }

    public static boolean isNight(World world) {
        long time = world.func_72820_D() % 24000L;
        return !world.func_230315_m_().func_241514_p_() && time > 12786L && time < 23216L;
    }

    public static boolean isFullMoon(World world) {
        long time = world.func_72820_D() % 192000L;
        return !world.func_230315_m_().func_241514_p_() && time > 12786L && time < 23216L;
    }

    public static Map<Item, Integer> getMissingItems(IInventory inventory, Item[] items, int[] amount) {
        int i;
        HashMap<Item, Integer> missing = new HashMap<Item, Integer>();
        for (i = 0; i < items.length; ++i) {
            missing.put(items[i], amount[i]);
        }
        for (i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            missing.computeIfPresent(stack.func_77973_b(), (item, amount1) -> amount1 - stack.func_190916_E());
        }
        missing.entrySet().removeIf(s -> (Integer)s.getValue() <= 0);
        return missing;
    }

    public static BiteDamageSource causeWerewolfDamage(String cause, Entity entity) {
        return new BiteDamageSource(cause, entity);
    }

    public static BiteDamageSource causeWerewolfDamage(PlayerEntity entity) {
        return Helper.causeWerewolfDamage("player", (Entity)entity);
    }

    public static boolean canWerewolfEatItem(ItemStack stack) {
        return !stack.func_222117_E() || ModTags.Items.COOKEDMEATS.func_230235_a_((Object)stack.func_77973_b()) || WerewolvesConfig.SERVER.isCustomMeatItems(stack.func_77973_b()) || ModTags.Items.RAWMEATS.func_230235_a_((Object)stack.func_77973_b()) || WerewolvesConfig.SERVER.isCustomRawMeatItems(stack.func_77973_b()) || stack.func_77973_b().func_219967_s().func_221467_c();
    }

    public static boolean canWerewolfPlayerEatItem(PlayerEntity player, ItemStack stack) {
        return Helper.canWerewolfEatItem(stack) || WerewolfPlayer.getOpt(player).map(w -> w.getSkillHandler().isSkillEnabled((ISkill)WerewolfSkills.NOT_MEAT.get())).orElse(false) != false;
    }

    public static boolean isRawMeat(ItemStack stack) {
        return stack.func_222117_E() && stack.func_77973_b().func_219967_s().func_221467_c() && ModTags.Items.RAWMEATS.func_230235_a_((Object)stack.func_77973_b());
    }

    public static IWerewolf asIWerewolf(LivingEntity entity) {
        if (entity instanceof IWerewolf) {
            return (IWerewolf)entity;
        }
        if (entity instanceof PlayerEntity) {
            return WerewolfPlayer.get((PlayerEntity)entity);
        }
        return null;
    }

    public static boolean matchesItem(Ingredient ingredient, ItemStack searchStack) {
        return Arrays.stream(ingredient.func_193365_a()).anyMatch(stack -> stack.func_77969_a(searchStack) && stack.areShareTagsEqual(searchStack));
    }

    public static IFormattableTextComponent joinComponents(String delimiter, IFormattableTextComponent ... components) {
        IFormattableTextComponent comp = components[0];
        for (int i = 1; i < components.length; ++i) {
            comp.func_240702_b_(delimiter).func_230529_a_((ITextComponent)components[i]);
        }
        return comp;
    }
}

