/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.util;

import de.teamlapen.werewolves.util.WerewolfSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.Pose;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;

public class WerewolfForm {
    private static final Map<String, WerewolfForm> REGISTRY = new HashMap<String, WerewolfForm>();
    public static final WerewolfForm NONE = new WerewolfForm("none", null, true, false, 0, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)));
    public static final WerewolfForm HUMAN = new WerewolfForm("human", null, true, true, 3, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.5f)));
    public static final WerewolfForm BEAST = new WerewolfForm("beast", WerewolfSize.BEAST, false, true, 8, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(3.0f)));
    public static final WerewolfForm BEAST4L = new WerewolfForm("beast4l", WerewolfSize.BEAST, false, true, 8, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(3.0f)));
    public static final WerewolfForm SURVIVALIST = new WerewolfForm("survivalist", WerewolfSize.SURVIVAL, false, true, 8, (Pair<Float, Float>)Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(2.5f)));
    @Nonnull
    private final String name;
    @Nullable
    private final Map<Pose, EntitySize> sizeMap;
    private final boolean humanLike;
    private final boolean transformed;
    private final int skinTypes;
    private final ITextComponent textComponent;
    private final Pair<Float, Float> damageReduction;

    WerewolfForm(@Nonnull String name, @Nullable Map<Pose, EntitySize> sizeMap, boolean humanLike, boolean transformed, int skinTypes, Pair<Float, Float> damageReduction) {
        if (REGISTRY.containsKey(name)) {
            throw new IllegalStateException("this name already exists");
        }
        REGISTRY.put(name, this);
        if (sizeMap == null) {
            sizeMap = new HashMap<Pose, EntitySize>();
        }
        this.name = name;
        this.sizeMap = sizeMap;
        this.humanLike = humanLike;
        this.transformed = transformed;
        this.skinTypes = skinTypes;
        this.textComponent = new TranslationTextComponent("form.werewolves." + name);
        this.damageReduction = damageReduction;
    }

    public boolean isHumanLike() {
        return this.humanLike;
    }

    public boolean isTransformed() {
        return this.transformed;
    }

    public Pair<Float, Float> getDamageReduction() {
        return this.damageReduction;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public Optional<EntitySize> getSize(Pose pose) {
        if (this.sizeMap != null) {
            return Optional.ofNullable(this.sizeMap.getOrDefault(pose, this.sizeMap.get(Pose.STANDING)));
        }
        return Optional.empty();
    }

    public ITextComponent getTextComponent() {
        return this.textComponent.func_230531_f_();
    }

    public int getSkinTypes() {
        return this.skinTypes;
    }

    public static WerewolfForm getForm(String name) {
        return REGISTRY.get(name);
    }

    public static Collection<WerewolfForm> getAllForms() {
        return new ArrayList<WerewolfForm>(REGISTRY.values());
    }
}

