/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world;

import com.google.common.collect.ImmutableList;
import de.teamlapen.werewolves.blocks.WolfsbaneBlock;
import de.teamlapen.werewolves.core.ModBlocks;
import java.util.List;
import java.util.OptionalInt;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;

public class WerewolvesBiomeFeatures {
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> jacaranda_tree;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> magic_tree;
    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> magic_tree_big;
    public static ConfiguredFeature<?, ?> werewolf_heaven_trees;
    public static ConfiguredFeature<?, ?> wolfsbane;
    public static ConfiguredFeature<?, ?> silver_ore;

    public static void registerBiomeFeatures() {
        jacaranda_tree = WerewolvesBiomeFeatures.registerFeature("jacaranda_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)ModBlocks.JACARANDA_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((LeavesBlock)ModBlocks.JACARANDA_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_()));
        magic_tree = WerewolvesBiomeFeatures.registerFeature("magic_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)ModBlocks.MAGIC_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((LeavesBlock)ModBlocks.MAGIC_LEAVES.get()).func_176223_P()), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(4, 2, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_()));
        magic_tree_big = WerewolvesBiomeFeatures.registerFeature("magic_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((RotatedPillarBlock)ModBlocks.MAGIC_LOG.get()).func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(((LeavesBlock)ModBlocks.MAGIC_LEAVES.get()).func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 1, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_()));
        werewolf_heaven_trees = WerewolvesBiomeFeatures.registerFeature("werewolf_heaven_trees", Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)jacaranda_tree.func_227227_a_(0.4f), (Object)Features.field_243869_bO.func_227227_a_(0.1f), (Object)magic_tree_big.func_227227_a_(0.1f)), magic_tree)).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(10, 0.1f, 1))));
        wolfsbane = WerewolvesBiomeFeatures.registerFeature("wolfsbane", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((WolfsbaneBlock)ModBlocks.WOLFSBANE.get()).func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(32).func_227322_d_()).func_242730_a(FeatureSpread.func_242253_a((int)-1, (int)4))).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(1));
        silver_ore = WerewolvesBiomeFeatures.registerFeature("silver_ore", (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((OreBlock)ModBlocks.SILVER_ORE.get()).func_176223_P(), 5)).func_242733_d(45)).func_242728_a()).func_242731_b(2));
    }

    private static <T extends IFeatureConfig> ConfiguredFeature<T, ?> registerFeature(String name, ConfiguredFeature<T, ?> feature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)new ResourceLocation("werewolves", name), feature);
    }

    public static void addWerewolvesFlowers(BiomeGenerationSettings.Builder biomeGeneratorSettings) {
        biomeGeneratorSettings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, wolfsbane);
    }

    public static void addWerewolfBiomeTrees(BiomeGenerationSettings.Builder biomeGeneratorSettings) {
        biomeGeneratorSettings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, werewolf_heaven_trees);
    }

    public static void init() {
    }
}

