/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world.loot;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.werewolves.util.WUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.conditions.Alternative;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

@ParametersAreNonnullByDefault
public class MobLootModifier
extends LootModifier {
    private final LootTable lootTable;

    public MobLootModifier(ILootCondition[] conditionsIn, LootTable lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        this.lootTable.func_216114_a(context, LootTable.func_216124_a(generatedLoot::add));
        return generatedLoot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class ModLootModifierSerializer
    extends GlobalLootModifierSerializer<MobLootModifier> {
        private static final Gson LOOT_TABLE_SERIALIZER = LootSerializers.func_237388_c_().create();

        public MobLootModifier read(ResourceLocation location, JsonObject object, ILootCondition[] lootConditions) {
            return new MobLootModifier(lootConditions, ForgeHooks.loadLootTable((Gson)LOOT_TABLE_SERIALIZER, (ResourceLocation)location, (JsonElement)object.get("loottable"), (boolean)true, (LootTableManager)WUtils.LOOT_TABLE_MANAGER));
        }

        public JsonObject write(MobLootModifier instance) {
            JsonObject obj = this.makeConditions(instance.conditions);
            obj.add("loottable", LOOT_TABLE_SERIALIZER.toJsonTree((Object)instance.lootTable));
            return obj;
        }
    }

    public static class Builder {
        private LootTable lootTable;
        private final List<EntityType<?>> entityTypes = new ArrayList();

        public Builder table(LootTable.Builder table) {
            this.lootTable = table.func_216038_b();
            return this;
        }

        public Builder onlyFor(EntityType<?> ... types) {
            return this.onlyFor(Arrays.asList(types));
        }

        public Builder onlyFor(List<EntityType<?>> types) {
            this.entityTypes.addAll(types);
            return this;
        }

        public MobLootModifier build() {
            if (this.entityTypes.isEmpty()) {
                throw new IllegalStateException("You must specify target entities");
            }
            return new MobLootModifier(new ILootCondition[]{this.entityTypes.stream().map(type -> EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_203998_a(type))).collect(() -> new Alternative.Builder(new ILootCondition.IBuilder[0]), Alternative.Builder::func_216297_a, Alternative.Builder::func_216297_a).build()}, this.lootTable);
        }
    }
}

