/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.cave;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseGen;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverSettings;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ICarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cave.CaveCarverBuilder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;

public class CaveCarver
implements ICarver {
    private CarverSettings settings;
    private NoiseGen noiseGen;
    private int surfaceCutoff;
    private int bottomY;
    private int topY;
    private boolean enableYAdjust;
    private float yAdjustF1;
    private float yAdjustF2;

    public CaveCarver(CaveCarverBuilder builder) {
        this.settings = builder.getSettings();
        this.noiseGen = new NoiseGen(this.settings.getSeed(), this.settings.isFastNoise(), this.settings.getNoiseSettings(), this.settings.getNumGens(), this.settings.getyCompression(), this.settings.getXzCompression());
        this.surfaceCutoff = builder.getSurfaceCutoff();
        this.bottomY = builder.getBottomY();
        this.topY = builder.getTopY();
        this.enableYAdjust = builder.isEnableYAdjust();
        this.yAdjustF1 = builder.getyAdjustF1();
        this.yAdjustF2 = builder.getyAdjustF2();
        if (this.bottomY > this.topY) {
            BetterCaves.LOGGER.warn("Warning: Min altitude for caves should not be greater than max altitude.");
            BetterCaves.LOGGER.warn("Using default values...");
            this.bottomY = 1;
            this.topY = 80;
        }
    }

    public void carveColumn(IChunk chunk, BlockPos colPos, int topY, double[][] noises, BlockState liquidBlock, boolean flooded, BitSet carvingMask) {
        int transitionBoundary;
        int localX = colPos.func_177958_n() & 0xF;
        int localZ = colPos.func_177952_p() & 0xF;
        if (this.bottomY < 0) {
            this.bottomY = 0;
        }
        if (this.bottomY > 255) {
            this.bottomY = 255;
        }
        if (topY < 0) {
            topY = 0;
        }
        if (topY > 255) {
            topY = 255;
        }
        if ((transitionBoundary = topY - this.surfaceCutoff) < 1) {
            transitionBoundary = 1;
        }
        Map<Integer, Float> thresholds = this.generateThresholds(topY, this.bottomY, transitionBoundary);
        if (this.enableYAdjust) {
            this.preprocessCaveNoiseCol(noises, topY, this.bottomY, thresholds, this.settings.getNumGens());
        }
        BlockPos.Mutable localPos = new BlockPos.Mutable(localX, 1, localZ);
        for (int y = topY; y >= this.bottomY && (y > this.settings.getLiquidAltitude() || liquidBlock != null); --y) {
            double[] noiseBlock = noises[y - this.bottomY];
            boolean digBlock = true;
            for (double noise : noiseBlock) {
                if (!(noise < (double)thresholds.get(y).floatValue())) continue;
                digBlock = false;
                break;
            }
            localPos.func_181079_c(localX, y, localZ);
            if (this.settings.isEnableDebugVisualizer()) {
                CarverUtils.debugCarveBlock(chunk, (BlockPos)localPos, this.settings.getDebugBlock(), digBlock);
                continue;
            }
            if (!digBlock) continue;
            if (flooded) {
                CarverUtils.carveFloodedBlock(chunk, new Random(), localPos, liquidBlock, this.settings.getLiquidAltitude(), this.settings.isReplaceFloatingGravel(), carvingMask);
                continue;
            }
            CarverUtils.carveBlock(chunk, (BlockPos)localPos, liquidBlock, this.settings.getLiquidAltitude(), this.settings.isReplaceFloatingGravel(), carvingMask);
        }
    }

    private void preprocessCaveNoiseCol(double[][] noises, int topY, int bottomY, Map<Integer, Float> thresholds, int numGens) {
        for (int y = topY; y >= bottomY; --y) {
            int yIndex = y - bottomY;
            double[] noiseBlock = noises[yIndex];
            float threshold = thresholds.get(y).floatValue();
            boolean valid = true;
            for (double noise : noiseBlock) {
                if (!(noise < (double)threshold)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            float f1 = this.yAdjustF1;
            float f2 = this.yAdjustF2;
            if (y < topY) {
                double[] tupleAbove = noises[yIndex + 1];
                for (int i = 0; i < numGens; ++i) {
                    tupleAbove[i] = (double)(1.0f - f1) * tupleAbove[i] + (double)f1 * noiseBlock[i];
                }
            }
            if (y >= topY - 1) continue;
            double[] tupleTwoAbove = noises[yIndex + 2];
            for (int i = 0; i < numGens; ++i) {
                tupleTwoAbove[i] = (double)(1.0f - f2) * tupleTwoAbove[i] + (double)f2 * noiseBlock[i];
            }
        }
    }

    private Map<Integer, Float> generateThresholds(int topY, int bottomY, int transitionBoundary) {
        HashMap<Integer, Float> thresholds = new HashMap<Integer, Float>();
        for (int realY = bottomY; realY <= topY; ++realY) {
            float noiseThreshold = this.settings.getNoiseThreshold();
            if (realY >= transitionBoundary) {
                noiseThreshold *= 1.0f + 0.3f * ((float)(realY - transitionBoundary) / (float)(topY - transitionBoundary));
            }
            thresholds.put(realY, Float.valueOf(noiseThreshold));
        }
        return thresholds;
    }

    public NoiseGen getNoiseGen() {
        return this.noiseGen;
    }

    public CarverSettings getSettings() {
        return this.settings;
    }

    @Override
    public int getPriority() {
        return this.settings.getPriority();
    }

    public int getBottomY() {
        return this.bottomY;
    }

    @Override
    public int getTopY() {
        return this.topY;
    }
}

