/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi;

import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.impl.Book;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class GuideConfig {
    public static Common COMMON;

    public static void buildConfiguration() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        ForgeConfigSpec commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, commonSpec);
        FMLJavaModLoadingContext.get().getModEventBus().register(GuideConfig.class);
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue canSpawnWithBook;
        public final ForgeConfigSpec.BooleanValue enableLogging;
        public final Map<Book, ForgeConfigSpec.BooleanValue> SPAWN_BOOKS = new HashMap<Book, ForgeConfigSpec.BooleanValue>();

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Common configurations settings").push("common");
            this.enableLogging = builder.comment("Enables extra information being printed to the console.").define("enableLogging", true);
            this.canSpawnWithBook = builder.comment("Allows books to spawn with new players.\nThis is a global override for all books if set to false.").define("canSpawnWithBook", true);
            builder.comment("If the player should spawn with this book").push("spawnBook");
            for (Book book : GuideAPI.getBooks().values()) {
                this.SPAWN_BOOKS.put(book, builder.define(book.getRegistryName().func_110624_b() + "-" + book.getRegistryName().func_110623_a(), book.shouldSpawnWithBook()));
            }
            builder.pop();
            builder.pop();
        }
    }
}

