/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi;

import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.IGuideBook;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.util.AnnotationHandler;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="guideapi-vp", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistrarGuideAPIClient {
    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
        for (Pair<Book, IGuideBook> guide : AnnotationHandler.BOOK_CLASSES) {
            ResourceLocation loc = ((IGuideBook)guide.getRight()).getModel();
            if (loc == null) continue;
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(loc, "inventory"));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void bakeModel(ModelBakeEvent event) {
        for (Pair<Book, IGuideBook> guide : AnnotationHandler.BOOK_CLASSES) {
            ResourceLocation loc = ((IGuideBook)guide.getRight()).getModel();
            if (loc == null) continue;
            ModelResourceLocation newMrl = new ModelResourceLocation(loc, "inventory");
            Item bookItem = GuideAPI.getStackFromBook((Book)guide.getLeft()).func_77973_b();
            ModelResourceLocation oldMrl = new ModelResourceLocation(bookItem.getRegistryName(), "inventory");
            IBakedModel model = (IBakedModel)event.getModelRegistry().get(newMrl);
            event.getModelRegistry().put(oldMrl, model);
        }
    }
}

