/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api;

import de.maxanier.guideapi.api.impl.Book;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class BookEvent
extends Event {
    private final Book book;
    private final ItemStack stack;
    private final PlayerEntity player;

    protected BookEvent(Book book, ItemStack stack, PlayerEntity player) {
        this.book = book;
        this.stack = stack;
        this.player = player;
    }

    public Book getBook() {
        return this.book;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    @Cancelable
    public static class Open
    extends BookEvent {
        private static final ITextComponent DEFAULT_CANCEL = new TranslationTextComponent("text.open.failed").func_240699_a_(TextFormatting.RED);
        private ITextComponent canceledText = DEFAULT_CANCEL;

        public Open(Book book, ItemStack stack, PlayerEntity player) {
            super(book, stack, player);
        }

        @Nonnull
        public ITextComponent getCanceledText() {
            return this.canceledText;
        }

        public void setCanceledText(@Nonnull ITextComponent canceledText) {
            this.canceledText = canceledText;
        }
    }
}

