/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.impl;

import com.google.common.base.Joiner;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.util.LogHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Book {
    private final List<CategoryAbstract> categories = new ArrayList<CategoryAbstract>();
    private final Consumer<List<CategoryAbstract>> contentProvider;
    private final ITextComponent title;
    private final ITextComponent header;
    private final ITextComponent itemName;
    private final ITextComponent author;
    private final ResourceLocation pageTexture;
    private final ResourceLocation outlineTexture;
    private final Color color;
    private final boolean spawnWithBook;
    private final ResourceLocation registryName;
    private final ItemGroup creativeTab;
    private boolean isInitialized;

    protected Book(Consumer<List<CategoryAbstract>> contentProvider, ITextComponent title, ITextComponent header, ITextComponent displayName, ITextComponent author, ResourceLocation pageTexture, ResourceLocation outlineTexture, Color color, boolean spawnWithBook, ResourceLocation registryName, ItemGroup creativeTab) {
        this.contentProvider = contentProvider;
        this.title = title;
        this.header = header;
        this.itemName = displayName;
        this.author = author;
        this.pageTexture = pageTexture;
        this.outlineTexture = outlineTexture;
        this.color = color;
        this.spawnWithBook = spawnWithBook;
        this.registryName = registryName;
        this.creativeTab = creativeTab;
    }

    public void initializeContent() {
        if (!this.isInitialized) {
            LogHelper.debug("Opening book " + this.registryName.toString() + " for the first time -> Initializing content");
            this.contentProvider.accept(this.categories);
            this.isInitialized = true;
        }
    }

    public void forceInitializeContent() {
        LogHelper.info("Force initializing book content " + this.registryName.toString());
        this.categories.clear();
        this.isInitialized = false;
        this.initializeContent();
    }

    public List<CategoryAbstract> getCategoryList() {
        return this.categories;
    }

    public ITextComponent getAuthor() {
        return this.author;
    }

    public ITextComponent getHeader() {
        return this.header;
    }

    public ITextComponent getItemName() {
        return this.itemName;
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public ResourceLocation getPageTexture() {
        return this.pageTexture;
    }

    public ResourceLocation getOutlineTexture() {
        return this.outlineTexture;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean shouldSpawnWithBook() {
        return this.spawnWithBook;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public ItemGroup getCreativeTab() {
        return this.creativeTab;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("categoryList", (Object)Joiner.on((String)", ").join(this.categories)).append("title", (Object)this.title).append("header", (Object)this.header).append("itemName", (Object)this.itemName).append("author", (Object)this.author).append("pageTexture", (Object)this.pageTexture).append("outlineTexture", (Object)this.outlineTexture).append("color", (Object)this.color).append("spawnWithBook", this.spawnWithBook).append("registryName", (Object)this.registryName).append("creativeTab", (Object)this.creativeTab).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Book book = (Book)o;
        return this.getRegistryName().equals((Object)book.getRegistryName());
    }

    public int hashCode() {
        return this.getRegistryName().hashCode();
    }
}

