/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.impl;

import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class BookBinder {
    private final ResourceLocation registryName;
    private Consumer<List<CategoryAbstract>> contentProvider;
    @Nonnull
    private ITextComponent guideTitle = new TranslationTextComponent("item.guideapi.book");
    @Nullable
    private ITextComponent header;
    @Nullable
    private ITextComponent itemName;
    @Nullable
    private ITextComponent author;
    private ResourceLocation pageTexture = new ResourceLocation("guideapi-vp", "textures/gui/book_colored.png");
    private ResourceLocation outlineTexture = new ResourceLocation("guideapi-vp", "textures/gui/book_greyscale.png");
    private Color color = new Color(171, 70, 30);
    private boolean spawnWithBook;
    private ItemGroup creativeTab = ItemGroup.field_78026_f;

    public BookBinder(ResourceLocation registryName) {
        this.registryName = registryName;
    }

    public BookBinder setContentProvider(Consumer<List<CategoryAbstract>> contentProvider) {
        this.contentProvider = contentProvider;
        return this;
    }

    public Book build() {
        if (this.author == null) {
            this.author = new StringTextComponent(ModList.get().getModContainerById(this.registryName.func_110624_b()).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse("Unknown"));
        }
        if (this.header == null) {
            this.header = this.guideTitle;
        }
        if (this.itemName == null) {
            this.itemName = this.guideTitle;
        }
        if (this.contentProvider == null) {
            throw new IllegalStateException("Content supplier of book " + this.registryName.toString() + " must be provided");
        }
        return new Book(this.contentProvider, this.guideTitle, this.header, this.itemName, this.author, this.pageTexture, this.outlineTexture, this.color, this.spawnWithBook, this.registryName, this.creativeTab);
    }

    public BookBinder setAuthor(ITextComponent author) {
        this.author = author;
        return this;
    }

    public BookBinder setGuideTitle(ITextComponent guideTitle) {
        this.guideTitle = guideTitle;
        return this;
    }

    public BookBinder setGuideTitleKey(String translationKey) {
        return this.setGuideTitle((ITextComponent)new TranslationTextComponent(translationKey));
    }

    public BookBinder setHeader(ITextComponent header) {
        this.header = header;
        return this;
    }

    public BookBinder setHeaderKey(String translationKey) {
        return this.setHeader((ITextComponent)new TranslationTextComponent(translationKey));
    }

    public BookBinder setItemName(ITextComponent itemName) {
        this.itemName = itemName;
        return this;
    }

    public BookBinder setPageTexture(ResourceLocation pageTexture) {
        this.pageTexture = pageTexture;
        return this;
    }

    public BookBinder setOutlineTexture(ResourceLocation outlineTexture) {
        this.outlineTexture = outlineTexture;
        return this;
    }

    public BookBinder setColor(Color color) {
        this.color = color;
        return this;
    }

    public BookBinder setColor(int color) {
        return this.setColor(new Color(color));
    }

    public BookBinder setSpawnWithBook() {
        this.spawnWithBook = true;
        return this;
    }

    public BookBinder setCreativeTab(ItemGroup creativeTab) {
        this.creativeTab = creativeTab;
        return this;
    }

    public BookBinder setItemNameKey(String translationKey) {
        return this.setItemName((ITextComponent)new TranslationTextComponent(translationKey));
    }
}

