/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.impl.abstraction;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.HomeScreen;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class CategoryAbstract {
    public final Map<ResourceLocation, EntryAbstract> entries;
    public final ITextComponent name;
    private String keyBase;

    public CategoryAbstract(Map<ResourceLocation, EntryAbstract> entries, ITextComponent name) {
        this.entries = entries;
        this.name = name;
    }

    public CategoryAbstract(ITextComponent name) {
        this(Maps.newLinkedHashMap(), name);
    }

    public void addEntry(ResourceLocation key, EntryAbstract entry) {
        this.entries.put(key, entry);
    }

    public void addEntry(String key, EntryAbstract entry) {
        if (Strings.isNullOrEmpty((String)this.keyBase)) {
            throw new RuntimeException("keyBase in category with name '" + this.name + "' must be set.");
        }
        this.addEntry(new ResourceLocation(this.keyBase, key), entry);
    }

    public void removeEntry(ResourceLocation key) {
        this.entries.remove(key);
    }

    public void addEntries(Map<ResourceLocation, EntryAbstract> entries) {
        this.entries.putAll(entries);
    }

    public void removeEntries(List<ResourceLocation> keys) {
        for (ResourceLocation key : keys) {
            this.entries.remove(key);
        }
    }

    public EntryAbstract getEntry(ResourceLocation key) {
        return this.entries.get(key);
    }

    public EntryAbstract getEntry(String key) {
        if (Strings.isNullOrEmpty((String)this.keyBase)) {
            throw new RuntimeException("keyBase in category with name '" + this.name.getString() + "' must be set.");
        }
        return this.getEntry(new ResourceLocation(this.keyBase, key));
    }

    public CategoryAbstract withKeyBase(String keyBase) {
        this.keyBase = keyBase;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void draw(MatrixStack var1, Book var2, int var3, int var4, int var5, int var6, int var7, int var8, BaseScreen var9, boolean var10, ItemRenderer var11);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawExtras(MatrixStack var1, Book var2, int var3, int var4, int var5, int var6, int var7, int var8, BaseScreen var9, boolean var10, ItemRenderer var11);

    public ITextComponent getName() {
        return this.name;
    }

    public List<ITextComponent> getTooltip() {
        return Lists.newArrayList((Object[])new ITextComponent[]{this.getName()});
    }

    public abstract boolean canSee(PlayerEntity var1, ItemStack var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onLeftClicked(Book var1, double var2, double var4, PlayerEntity var6, ItemStack var7);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onRightClicked(Book var1, double var2, double var4, PlayerEntity var6, ItemStack var7);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onInit(Book var1, HomeScreen var2, PlayerEntity var3, ItemStack var4);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CategoryAbstract that = (CategoryAbstract)o;
        if (this.entries != null ? !this.entries.equals(that.entries) : that.entries != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.entries != null ? this.entries.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

