/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.impl.abstraction;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.CategoryScreen;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EntryAbstract {
    public final List<IPage> pageList;
    public final ITextComponent name;

    public EntryAbstract(List<IPage> pageList, ITextComponent name) {
        this.pageList = pageList;
        this.name = name;
    }

    public EntryAbstract(ITextComponent name) {
        this(Lists.newArrayList(), name);
    }

    public void addPage(IPage page) {
        this.pageList.add(page);
    }

    public void removePage(IPage page) {
        this.pageList.remove(page);
    }

    public void addPageList(List<IPage> pages) {
        this.pageList.addAll(pages);
    }

    public void removePageList(List<IPage> pages) {
        this.pageList.removeAll(pages);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void draw(MatrixStack var1, Book var2, CategoryAbstract var3, int var4, int var5, int var6, int var7, int var8, int var9, BaseScreen var10, FontRenderer var11);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void drawExtras(MatrixStack var1, Book var2, CategoryAbstract var3, int var4, int var5, int var6, int var7, int var8, int var9, BaseScreen var10, FontRenderer var11);

    public ITextComponent getName() {
        return this.name;
    }

    public abstract boolean canSee(PlayerEntity var1, ItemStack var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onLeftClicked(Book var1, CategoryAbstract var2, double var3, double var5, PlayerEntity var7, CategoryScreen var8);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onRightClicked(Book var1, CategoryAbstract var2, double var3, double var5, PlayerEntity var7, CategoryScreen var8);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onInit(Book var1, CategoryAbstract var2, CategoryScreen var3, PlayerEntity var4, ItemStack var5);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryAbstract that = (EntryAbstract)o;
        if (this.pageList != null ? !this.pageList.equals(that.pageList) : that.pageList != null) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.pageList != null ? this.pageList.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

