/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiHelper {
    private static final ItemRenderer render = Minecraft.func_71410_x().func_175599_af();

    public static boolean isMouseBetween(double mouseX, double mouseY, int x, int y, int width, int height) {
        int xSize = x + width;
        int ySize = y + height;
        return mouseX >= (double)x && mouseX <= (double)xSize && mouseY >= (double)y && mouseY <= (double)ySize;
    }

    public static void drawItemStack(MatrixStack mStack, ItemStack stack, int x, int y) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.func_227780_a_();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableDepthTest();
        render.func_180450_b(stack, x, y);
        render.func_180453_a(Minecraft.func_71410_x().field_71466_p, stack, x, y, null);
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
        RenderSystem.disableLighting();
    }

    public static void drawScaledItemStack(MatrixStack mStack, ItemStack stack, int x, int y, float scale) {
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)scale, (float)scale, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.func_227780_a_();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableDepthTest();
        render.func_180450_b(stack, (int)((float)x / scale), (int)((float)y / scale));
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
    }

    public static void drawIconWithoutColor(MatrixStack mStack, int x, int y, int width, int height, float zLevel) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.func_227780_a_();
        RenderSystem.disableLighting();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableDepthTest();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_(1.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
    }

    public static void drawIconWithColor(MatrixStack mStack, int x, int y, int width, int height, float zLevel, Color color) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.func_227780_a_();
        RenderSystem.disableLighting();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableDepthTest();
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_(1.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderHelper.func_74518_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public static void drawSizedIconWithoutColor(MatrixStack mStack, int x, int y, int width, int height, float zLevel) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        RenderSystem.translatef((float)x, (float)y, (float)zLevel);
        RenderHelper.func_227780_a_();
        RenderSystem.disableLighting();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableDepthTest();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_(1.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
    }

    public static void drawSizedIconWithColor(MatrixStack mStack, int x, int y, int width, int height, float zLevel, Color color) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        RenderSystem.translatef((float)x, (float)y, (float)zLevel);
        RenderHelper.func_227780_a_();
        RenderSystem.disableLighting();
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableDepthTest();
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_225582_a_((double)x, (double)(y + height), (double)zLevel).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + width), (double)(y + height), (double)zLevel).func_225583_a_(1.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + width), (double)y, (double)zLevel).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)x, (double)y, (double)zLevel).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderHelper.func_74518_a();
        RenderSystem.popMatrix();
    }

    public static List<ITextComponent> getTooltip(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        List list = stack.func_82840_a((PlayerEntity)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int k = 0; k < list.size(); ++k) {
            ITextComponent c = (ITextComponent)list.get(k);
            if (!(c instanceof IFormattableTextComponent)) continue;
            if (k == 0) {
                ((IFormattableTextComponent)c).func_240699_a_(stack.func_77953_t().field_77937_e);
                continue;
            }
            ((IFormattableTextComponent)c).func_240699_a_(TextFormatting.GRAY);
        }
        return list;
    }
}

