/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.util;

import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.BookHelper;
import de.maxanier.guideapi.api.util.PageHelper;
import de.maxanier.guideapi.entry.EntryItemStack;
import de.maxanier.guideapi.page.PageBrewingRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.brewing.BrewingRecipe;
import org.apache.logging.log4j.LogManager;

public class ItemInfoBuilder {
    private final boolean block;
    private final BookHelper bookHelper;
    private final Ingredient ingredient;
    private final ItemStack mainStack;
    private String name;
    private Object[] formats = new Object[0];
    private Object[] links = null;
    private boolean customName;
    @Nonnull
    private List<ResourceLocation> recipes = Collections.emptyList();
    @Nullable
    private ItemStack[] brewingStacks;
    private final List<IPage> additionalPages = new ArrayList<IPage>();

    protected ItemInfoBuilder(BookHelper bookHelper, Ingredient ingredient, ItemStack mainStack, String name, boolean block) {
        this.ingredient = ingredient;
        this.block = block;
        this.mainStack = mainStack;
        this.name = name;
        this.bookHelper = bookHelper;
    }

    public ItemInfoBuilder brewingItems(Item ... brewableItems) {
        this.brewingStacks = (ItemStack[])Arrays.stream(brewableItems).map(ItemStack::new).toArray(ItemStack[]::new);
        return this;
    }

    public ItemInfoBuilder brewingStacks(ItemStack ... brewableStacks) {
        this.brewingStacks = brewableStacks;
        return this;
    }

    public void build(Map<ResourceLocation, EntryAbstract> entries) {
        ArrayList<IPage> pages = new ArrayList<IPage>();
        String base = this.bookHelper.getBaseKey() + (this.block ? ".blocks" : ".items") + "." + this.name;
        pages.addAll(PageHelper.pagesForLongText((ITextProperties)this.bookHelper.localize(base + ".text", this.formats), this.ingredient));
        for (ResourceLocation id : this.recipes) {
            pages.add(this.bookHelper.getRecipePage(id));
        }
        if (this.brewingStacks != null) {
            for (ItemStack brew : this.brewingStacks) {
                BrewingRecipe r = this.bookHelper.getBrewingRecipe(brew);
                if (r == null) {
                    LogManager.getLogger().error("Could not find brewing recipe for {}", (Object)brew.toString());
                    continue;
                }
                pages.add(new PageBrewingRecipe(r));
            }
        }
        pages.addAll(this.additionalPages);
        if (this.links != null) {
            this.bookHelper.addLinks(pages, this.links);
        }
        entries.put(new ResourceLocation(base), new EntryItemStack(pages, (ITextComponent)new TranslationTextComponent(this.customName ? base : this.mainStack.func_77977_a()), this.mainStack));
    }

    public ItemInfoBuilder recipes(String ... modIDs) {
        this.recipes = Arrays.stream(modIDs).map(id -> new ResourceLocation(this.bookHelper.getModid(), id)).collect(Collectors.toList());
        return this;
    }

    public ItemInfoBuilder recipes(ResourceLocation ... ids) {
        this.recipes = Arrays.asList(ids);
        return this;
    }

    public ItemInfoBuilder setFormats(Object ... formats) {
        this.formats = formats;
        return this;
    }

    public ItemInfoBuilder setKeyName(String name) {
        this.name = name;
        return this;
    }

    public ItemInfoBuilder setLinks(Object ... links) {
        this.links = links;
        return this;
    }

    public ItemInfoBuilder useCustomEntryName() {
        this.customName = true;
        return this;
    }

    public ItemInfoBuilder customPages(IPage ... additionalPages) {
        this.additionalPages.addAll(Arrays.asList(additionalPages));
        return this;
    }
}

