/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.api.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.page.PageItemStack;
import de.maxanier.guideapi.page.PageText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class PageHelper {
    public static List<ITextProperties> prepareForLongText(ITextProperties text, int lineWidth, int firstHeight, int subsequentHeight) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.getClass();
        int firstCount = firstHeight / 9;
        fontRenderer.getClass();
        int count = subsequentHeight / 9;
        ArrayList<ITextProperties> lines = new ArrayList<ITextProperties>(fontRenderer.func_238420_b_().func_238362_b_(text, lineWidth, Style.field_240709_b_));
        ArrayList<ITextProperties> pages = new ArrayList<ITextProperties>();
        ArrayList<ITextProperties> pageLines = lines.size() > firstCount ? lines.subList(0, firstCount) : lines;
        pages.add(PageHelper.combineWithNewLine(pageLines));
        pageLines.clear();
        while (lines.size() > 0) {
            pageLines = lines.size() > count ? lines.subList(0, count) : lines;
            pages.add(PageHelper.combineWithNewLine(pageLines));
            pageLines.clear();
        }
        return pages;
    }

    public static List<IPage> pagesForLongText(ITextProperties text, Ingredient ingredient) {
        List<ITextProperties> pageText = PageHelper.prepareForLongText(text, 164, 81, 120);
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        for (int i = 0; i < pageText.size(); ++i) {
            if (i == 0) {
                pageList.add(new PageItemStack(pageText.get(i), ingredient));
                continue;
            }
            pageList.add(new PageText(pageText.get(i)));
        }
        return pageList;
    }

    public static List<IPage> pagesForLongText(ITextProperties text) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        PageHelper.prepareForLongText(text, 164, 126, 126).forEach(t -> pageList.add(new PageText((ITextProperties)t)));
        return pageList;
    }

    public static void drawFormattedText(MatrixStack stack, int x, int y, BaseScreen guiBase, ITextProperties toDraw) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        List cutLines = fontRenderer.func_238425_b_(toDraw, 170);
        for (IReorderingProcessor cut : cutLines) {
            fontRenderer.func_238422_b_(stack, cut, (float)x, (float)y, 0);
            y += 10;
        }
    }

    public static List<IPage> pagesForLongText(ITextProperties text, Item item) {
        return PageHelper.pagesForLongText(text, new ItemStack((IItemProvider)item));
    }

    public static List<IPage> pagesForLongText(ITextProperties text, Block block) {
        return PageHelper.pagesForLongText(text, new ItemStack((IItemProvider)block));
    }

    public static List<IPage> pagesForLongText(ITextProperties text, ItemStack item) {
        return PageHelper.pagesForLongText(text, Ingredient.func_193369_a((ItemStack[])new ItemStack[]{item}));
    }

    public static boolean areIRecipesEqual(IRecipe recipe1, IRecipe recipe2) {
        if (recipe1 == recipe2) {
            return true;
        }
        if (recipe1 == null || recipe2 == null || recipe1.getClass() != recipe2.getClass()) {
            return false;
        }
        if (recipe1.equals(recipe2)) {
            return true;
        }
        return recipe1.func_77571_b().func_77969_a(recipe2.func_77571_b());
    }

    private static ITextProperties combineWithNewLine(List<ITextProperties> elements) {
        StringTextComponent newLine = new StringTextComponent("\n");
        ArrayList<Object> copy = new ArrayList<Object>(elements.size() * 2);
        for (int i = 0; i < elements.size() - 1; ++i) {
            copy.add(elements.get(i));
            copy.add(newLine);
        }
        copy.add(elements.get(elements.size() - 1));
        return ITextProperties.func_240654_a_(copy);
    }
}

