/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Category;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import java.util.Map;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CategoryItemStack
extends Category {
    public ItemStack itemStack;

    public CategoryItemStack(Map<ResourceLocation, EntryAbstract> entries, ITextComponent name, ItemStack stack) {
        super(entries, name);
        this.itemStack = stack;
    }

    public CategoryItemStack(ITextComponent name, ItemStack stack) {
        super(name);
        this.itemStack = stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack stack, Book book, int categoryX, int categoryY, int categoryWidth, int categoryHeight, int mouseX, int mouseY, BaseScreen guiBase, boolean drawOnLeft, ItemRenderer renderItem) {
        GuiHelper.drawScaledItemStack(stack, this.itemStack, categoryX, categoryY, 1.5f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(MatrixStack stack, Book book, int categoryX, int categoryY, int categoryWidth, int categoryHeight, int mouseX, int mouseY, BaseScreen guiBase, boolean drawOnLeft, ItemRenderer renderItem) {
        if (this.canSee(guiBase.player, guiBase.bookStack) && GuiHelper.isMouseBetween(mouseX, mouseY, categoryX, categoryY, categoryWidth, categoryHeight)) {
            guiBase.func_243308_b(stack, this.getTooltip(), mouseX, mouseY);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategoryItemStack)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategoryItemStack that = (CategoryItemStack)o;
        return this.itemStack != null ? this.itemStack.equals(that.itemStack) : that.itemStack == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.itemStack != null ? this.itemStack.hashCode() : 0);
        return result;
    }
}

