/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.category;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Category;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CategoryResourceLocation
extends Category {
    public ResourceLocation resourceLocation;

    public CategoryResourceLocation(Map<ResourceLocation, EntryAbstract> entries, ITextComponent name, ResourceLocation resourceLocation) {
        super(entries, name);
        this.resourceLocation = resourceLocation;
    }

    public CategoryResourceLocation(ITextComponent name, ResourceLocation resourceLocation) {
        super(name);
        this.resourceLocation = resourceLocation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack stack, Book book, int categoryX, int categoryY, int categoryWidth, int categoryHeight, int mouseX, int mouseY, BaseScreen guiBase, boolean drawOnLeft, ItemRenderer renderItem) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.resourceLocation);
        GuiHelper.drawSizedIconWithoutColor(stack, categoryX, categoryY, 48, 48, 0.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(MatrixStack stack, Book book, int categoryX, int categoryY, int categoryWidth, int categoryHeight, int mouseX, int mouseY, BaseScreen guiBase, boolean drawOnLeft, ItemRenderer renderItem) {
        if (this.canSee(guiBase.player, guiBase.bookStack) && GuiHelper.isMouseBetween(mouseX, mouseY, categoryX, categoryY, categoryWidth, categoryHeight)) {
            guiBase.func_243308_b(stack, this.getTooltip(), mouseX, mouseY);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CategoryResourceLocation)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategoryResourceLocation that = (CategoryResourceLocation)o;
        return this.resourceLocation != null ? this.resourceLocation.equals((Object)that.resourceLocation) : that.resourceLocation == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.resourceLocation != null ? this.resourceLocation.hashCode() : 0);
        return result;
    }
}

