/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.button.ButtonBack;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.button.ButtonSearch;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.HomeScreen;
import de.maxanier.guideapi.gui.SearchScreen;
import de.maxanier.guideapi.network.PacketHandler;
import de.maxanier.guideapi.network.PacketSyncCategory;
import de.maxanier.guideapi.wrapper.EntryWrapper;
import java.awt.Color;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class CategoryScreen
extends BaseScreen {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public HashMultimap<Integer, EntryWrapper> entryWrapperMap = HashMultimap.create();
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public ButtonSearch buttonSearch;
    public int entryPage;
    @Nullable
    public EntryAbstract startEntry;

    public CategoryScreen(Book book, CategoryAbstract category, PlayerEntity player, ItemStack bookStack, @Nullable EntryAbstract startEntry) {
        super(category.name, player, bookStack);
        this.book = book;
        this.category = category;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.entryPage = 0;
        this.startEntry = startEntry;
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        PacketHandler.INSTANCE.sendToServer((Object)new PacketSyncCategory(this.book.getCategoryList().indexOf(this.category), this.entryPage));
    }

    public void func_231160_c_() {
        this.entryWrapperMap.clear();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.buttonBack = new ButtonBack(this.guiLeft + this.xSize / 6, this.guiTop, btn -> this.field_230706_i_.func_147108_a((Screen)new HomeScreen(this.book, this.player, this.bookStack)), this);
        this.func_230480_a_((Widget)this.buttonBack);
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
                this.nextPage();
            }
        }, this);
        this.func_230480_a_((Widget)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.entryPage > 0) {
                this.prevPage();
            }
        }, this);
        this.func_230480_a_((Widget)this.buttonPrev);
        this.buttonSearch = new ButtonSearch(this.guiLeft + this.xSize / 6 - 25, this.guiTop + 5, btn -> this.field_230706_i_.func_147108_a((Screen)new SearchScreen(this.book, this.player, this.bookStack, this)), this);
        this.func_230480_a_((Widget)this.buttonSearch);
        int eX = this.guiLeft + 37;
        int eY = this.guiTop + 15;
        int i = 0;
        int pageNumber = 0;
        ArrayList entries = Lists.newArrayList(this.category.entries.values());
        for (EntryAbstract entry : entries) {
            entry.onInit(this.book, this.category, this, this.player, this.bookStack);
            this.entryWrapperMap.put((Object)pageNumber, (Object)new EntryWrapper(this, this.book, this.category, entry, eX, eY, 4 * this.xSize / 6, 10, this.player, this.field_230712_o_, this.bookStack));
            if (entry.equals(this.startEntry)) {
                this.startEntry = null;
                this.entryPage = pageNumber;
            }
            eY += 13;
            if (++i < 11) continue;
            i = 0;
            eY = this.guiTop + 15;
            ++pageNumber;
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 259 || keyCode == this.field_230706_i_.field_71474_y.field_74313_G.getKey().func_197937_c()) {
            this.field_230706_i_.func_147108_a((Screen)new HomeScreen(this.book, this.player, this.bookStack));
            return true;
        }
        if ((keyCode == 265 || keyCode == 262) && this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
            this.nextPage();
            return true;
        }
        if ((keyCode == 264 || keyCode == 263) && this.entryPage > 0) {
            this.prevPage();
            return true;
        }
        return super.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int typeofClick) {
        boolean ret = super.func_231044_a_(mouseX, mouseY, typeofClick);
        for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            if (typeofClick == 0) {
                wrapper.entry.onLeftClicked(this.book, this.category, mouseX, mouseY, this.player, this);
                continue;
            }
            if (typeofClick != 1) continue;
            wrapper.entry.onRightClicked(this.book, this.category, mouseX, mouseY, this.player, this);
        }
        if (typeofClick == 1) {
            this.field_230706_i_.func_147108_a((Screen)new HomeScreen(this.book, this.player, this.bookStack));
        }
        return ret;
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0) {
            this.nextPage();
        } else if (movement > 0.0) {
            this.prevPage();
        }
        return movement != 0.0 || super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float renderPartialTicks) {
        this.field_230706_i_.func_110434_K().func_110577_a(this.pageTexture);
        this.func_238474_b_(stack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.field_230706_i_.func_110434_K().func_110577_a(this.outlineTexture);
        this.drawTexturedModalRectWithColor(stack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.getColor());
        this.entryPage = MathHelper.func_76125_a((int)this.entryPage, (int)0, (int)(this.entryWrapperMap.size() - 1));
        for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
            if (wrapper.canPlayerSee()) {
                wrapper.draw(stack, mouseX, mouseY, this);
                wrapper.drawExtras(stack, mouseX, mouseY, this);
            }
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            wrapper.onHoverOver(mouseX, mouseY);
        }
        this.drawCenteredStringWithoutShadow(stack, this.field_230712_o_, String.format("%d/%d", this.entryPage + 1, this.entryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        CategoryScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.category.getName(), (int)(this.guiLeft + this.xSize / 2), (int)(this.guiTop - 10), (int)Color.WHITE.getRGB());
        this.buttonPrev.field_230694_p_ = this.entryPage != 0;
        this.buttonNext.field_230694_p_ = this.entryPage != this.entryWrapperMap.asMap().size() - 1 && !this.entryWrapperMap.asMap().isEmpty();
        super.func_230430_a_(stack, mouseX, mouseY, renderPartialTicks);
    }

    public void nextPage() {
        if (this.entryPage >= this.entryWrapperMap.asMap().size()) {
            this.entryPage = this.entryWrapperMap.asMap().size() - 1;
        }
        if (this.entryPage != this.entryWrapperMap.asMap().size() - 1 && !this.entryWrapperMap.asMap().isEmpty()) {
            ++this.entryPage;
        }
    }

    public void prevPage() {
        if (this.entryPage >= this.entryWrapperMap.asMap().size()) {
            this.entryPage = this.entryWrapperMap.asMap().size() - 1;
        }
        if (this.entryPage != 0) {
            --this.entryPage;
        }
    }
}

