/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.button.ButtonBack;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.button.ButtonSearch;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.CategoryScreen;
import de.maxanier.guideapi.gui.SearchScreen;
import de.maxanier.guideapi.network.PacketHandler;
import de.maxanier.guideapi.network.PacketSyncEntry;
import de.maxanier.guideapi.wrapper.PageWrapper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class EntryScreen
extends BaseScreen {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public EntryAbstract entry;
    public List<PageWrapper> pageWrapperList = new ArrayList<PageWrapper>();
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public ButtonSearch buttonSearch;
    public int pageNumber;

    public EntryScreen(Book book, CategoryAbstract category, EntryAbstract entry, PlayerEntity player, ItemStack bookStack) {
        super(entry.name, player, bookStack);
        this.book = book;
        this.category = category;
        this.entry = entry;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.pageNumber = 0;
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        for (IPage page : this.entry.pageList) {
            page.onClose();
        }
        ResourceLocation key = null;
        for (Map.Entry<ResourceLocation, EntryAbstract> mapEntry : this.category.entries.entrySet()) {
            if (!mapEntry.getValue().equals(this.entry)) continue;
            key = mapEntry.getKey();
        }
        if (key != null) {
            PacketHandler.INSTANCE.sendToServer((Object)new PacketSyncEntry(this.book.getCategoryList().indexOf(this.category), key, this.pageNumber));
        }
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.entry.onInit(this.book, this.category, null, this.player, this.bookStack);
        this.pageWrapperList.clear();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.buttonBack = new ButtonBack(this.guiLeft + this.xSize / 6, this.guiTop, btn -> this.field_230706_i_.func_147108_a((Screen)new CategoryScreen(this.book, this.category, this.player, this.bookStack, this.entry)), this);
        this.func_230480_a_((Widget)this.buttonBack);
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.pageNumber + 1 < this.pageWrapperList.size()) {
                this.nextPage();
            }
        }, this);
        this.func_230480_a_((Widget)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.pageNumber > 0) {
                this.prevPage();
            }
        }, this);
        this.func_230480_a_((Widget)this.buttonPrev);
        this.buttonSearch = new ButtonSearch(this.guiLeft + this.xSize / 6 - 25, this.guiTop + 5, btn -> this.field_230706_i_.func_147108_a((Screen)new SearchScreen(this.book, this.player, this.bookStack, this)), this);
        this.func_230480_a_((Widget)this.buttonSearch);
        for (IPage page : this.entry.pageList) {
            page.onInit(this.book, this.category, this.entry, this.player, this.bookStack, this);
            this.pageWrapperList.add(new PageWrapper(this, this.book, this.category, this.entry, page, this.guiLeft, this.guiTop, this.player, this.field_230712_o_, this.bookStack));
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 259 || keyCode == this.field_230706_i_.field_71474_y.field_74313_G.getKey().func_197937_c()) {
            this.field_230706_i_.func_147108_a((Screen)new CategoryScreen(this.book, this.category, this.player, this.bookStack, this.entry));
            return true;
        }
        if ((keyCode == 265 || keyCode == 262) && this.pageNumber + 1 < this.pageWrapperList.size()) {
            this.nextPage();
            return true;
        }
        if ((keyCode == 264 || keyCode == 263) && this.pageNumber > 0) {
            this.prevPage();
            return true;
        }
        return super.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int typeofClick) {
        if (!super.func_231044_a_(mouseX, mouseY, typeofClick)) {
            for (PageWrapper wrapper : this.pageWrapperList) {
                if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
                if (typeofClick == 0) {
                    this.pageWrapperList.get((int)this.pageNumber).page.onLeftClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
                    return true;
                }
                if (typeofClick != 1) continue;
                this.pageWrapperList.get((int)this.pageNumber).page.onRightClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
                return true;
            }
            if (typeofClick == 1) {
                this.field_230706_i_.func_147108_a((Screen)new CategoryScreen(this.book, this.category, this.player, this.bookStack, this.entry));
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0) {
            this.nextPage();
        } else if (movement > 0.0) {
            this.prevPage();
        }
        return movement != 0.0 || super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float renderPartialTicks) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.pageTexture);
        this.func_238474_b_(stack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.outlineTexture);
        this.drawTexturedModalRectWithColor(stack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.getColor());
        this.pageNumber = MathHelper.func_76125_a((int)this.pageNumber, (int)0, (int)(this.pageWrapperList.size() - 1));
        if (this.pageNumber < this.pageWrapperList.size() && this.pageWrapperList.get(this.pageNumber).canPlayerSee()) {
            this.pageWrapperList.get(this.pageNumber).draw(stack, mouseX, mouseY, this);
            this.pageWrapperList.get(this.pageNumber).drawExtras(stack, mouseX, mouseY, this);
        }
        this.drawCenteredStringWithoutShadow(stack, this.field_230712_o_, String.format("%d/%d", this.pageNumber + 1, this.pageWrapperList.size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        EntryScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.entry.getName(), (int)(this.guiLeft + this.xSize / 2), (int)(this.guiTop - 10), (int)Color.WHITE.getRGB());
        this.buttonPrev.field_230694_p_ = this.pageNumber != 0;
        this.buttonNext.field_230694_p_ = this.pageNumber != this.pageWrapperList.size() - 1 && !this.pageWrapperList.isEmpty();
        super.func_230430_a_(stack, mouseX, mouseY, renderPartialTicks);
    }

    public void nextPage() {
        if (this.pageNumber != this.pageWrapperList.size() - 1 && !this.pageWrapperList.isEmpty()) {
            ++this.pageNumber;
        }
    }

    public void prevPage() {
        if (this.pageNumber != 0) {
            --this.pageNumber;
        }
    }
}

