/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.button.ButtonSearch;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.SearchScreen;
import de.maxanier.guideapi.network.PacketHandler;
import de.maxanier.guideapi.network.PacketSyncHome;
import de.maxanier.guideapi.wrapper.CategoryWrapper;
import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class HomeScreen
extends BaseScreen {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public HashMultimap<Integer, CategoryWrapper> categoryWrapperMap = HashMultimap.create();
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public ButtonSearch buttonSearch;
    public int categoryPage;

    public HomeScreen(Book book, PlayerEntity player, ItemStack bookStack) {
        super(book.getTitle(), player, bookStack);
        this.book = book;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.categoryPage = 0;
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        PacketHandler.INSTANCE.sendToServer((Object)new PacketSyncHome(this.categoryPage));
    }

    public void func_231160_c_() {
        this.categoryWrapperMap.clear();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
                this.nextPage();
            }
        }, this);
        this.func_230480_a_((Widget)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.categoryPage > 0) {
                this.prevPage();
            }
        }, this);
        this.func_230480_a_((Widget)this.buttonPrev);
        this.buttonSearch = new ButtonSearch(this.guiLeft + this.xSize / 6 - 25, this.guiTop + 5, btn -> this.field_230706_i_.func_147108_a((Screen)new SearchScreen(this.book, this.player, this.bookStack, this)), this);
        this.func_230480_a_((Widget)this.buttonSearch);
        int cX = this.guiLeft + 55;
        int cY = this.guiTop + 40;
        int i = 0;
        int pageNumber = 0;
        for (CategoryAbstract category : this.book.getCategoryList()) {
            if (category.entries.isEmpty()) continue;
            category.onInit(this.book, this, this.player, this.bookStack);
            int x = i % 5;
            int y = i / 5;
            this.categoryWrapperMap.put((Object)pageNumber, (Object)new CategoryWrapper(this.book, category, cX + x * 27, cY + y * 30, 23, 23, this.player, this.field_230712_o_, this.field_230707_j_, false, this.bookStack));
            if (++i < 20) continue;
            i = 0;
            ++pageNumber;
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if ((keyCode == 265 || keyCode == 262) && this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
            this.nextPage();
        } else if ((keyCode == 264 || keyCode == 263) && this.categoryPage > 0) {
            this.prevPage();
        }
        return super.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int typeofClick) {
        if (!super.func_231044_a_(mouseX, mouseY, typeofClick)) {
            for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
                if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
                if (typeofClick == 0) {
                    wrapper.category.onLeftClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
                } else if (typeofClick == 1) {
                    wrapper.category.onRightClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0) {
            this.nextPage();
        } else if (movement > 0.0) {
            this.prevPage();
        }
        return movement != 0.0 || super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float renderPartialTicks) {
        this.field_230706_i_.func_110434_K().func_110577_a(this.pageTexture);
        this.func_238474_b_(stack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.field_230706_i_.func_110434_K().func_110577_a(this.outlineTexture);
        this.drawTexturedModalRectWithColor(stack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.getColor());
        this.drawCenteredStringWithoutShadow(stack, this.field_230712_o_, this.book.getHeader().func_241878_f(), this.guiLeft + this.xSize / 2 + 1, this.guiTop + 15, 0);
        this.categoryPage = MathHelper.func_76125_a((int)this.categoryPage, (int)0, (int)(this.categoryWrapperMap.size() - 1));
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.draw(stack, mouseX, mouseY, this);
        }
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.drawExtras(stack, mouseX, mouseY, this);
        }
        this.drawCenteredStringWithoutShadow(stack, this.field_230712_o_, String.format("%d/%d", this.categoryPage + 1, this.categoryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        HomeScreen.func_238472_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.book.getTitle(), (int)(this.guiLeft + this.xSize / 2), (int)(this.guiTop - 10), (int)Color.WHITE.getRGB());
        this.buttonPrev.field_230694_p_ = this.categoryPage != 0;
        this.buttonNext.field_230694_p_ = this.categoryPage != this.categoryWrapperMap.asMap().size() - 1 && !this.categoryWrapperMap.asMap().isEmpty();
        super.func_230430_a_(stack, mouseX, mouseY, renderPartialTicks);
    }

    public void nextPage() {
        if (this.categoryPage != this.categoryWrapperMap.asMap().size() - 1 && !this.categoryWrapperMap.asMap().isEmpty()) {
            ++this.categoryPage;
        }
    }

    public void prevPage() {
        if (this.categoryPage != 0) {
            --this.categoryPage;
        }
    }
}

