/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.GuideMod;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.button.ButtonBack;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.util.GuiUtilsCopy;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.glfw.GLFW;

public class SearchScreen
extends BaseScreen {
    private final Book book;
    private final ResourceLocation outlineTexture;
    private ButtonNext buttonNext;
    private ButtonPrev buttonPrev;
    private TextFieldWidget searchField;
    private final ResourceLocation pageTexture;
    private List<List<Pair<EntryAbstract, CategoryAbstract>>> searchResults;
    private int currentPage = 0;
    private String lastQuery = "";
    private final int renderXOffset = 37;
    private final int renderYOffset = 30;
    private final Screen parent;

    @Nonnull
    static List<List<Pair<EntryAbstract, CategoryAbstract>>> getMatches(Book book, @Nullable String query, PlayerEntity player, ItemStack bookStack) {
        ArrayList discovered = Lists.newArrayList();
        for (CategoryAbstract category : book.getCategoryList()) {
            if (!category.canSee(player, bookStack)) continue;
            for (EntryAbstract entry : category.entries.values()) {
                if (!entry.canSee(player, bookStack) || !Strings.isNullOrEmpty((String)query) && !entry.getName().getString().toLowerCase(Locale.ENGLISH).contains(query.toLowerCase(Locale.ENGLISH))) continue;
                discovered.add(Pair.of((Object)entry, (Object)category));
            }
        }
        return Lists.partition((List)discovered, (int)10);
    }

    public SearchScreen(Book book, PlayerEntity player, ItemStack bookStack, Screen parent) {
        super(book.getTitle(), player, bookStack);
        this.book = book;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.parent = parent;
        this.searchResults = SearchScreen.getMatches(book, null, player, bookStack);
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.func_231042_a_(p_charTyped_1_, p_charTyped_2_)) {
            this.updateSearch();
            return true;
        }
        return super.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    public void func_231160_c_() {
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.func_230480_a_((Widget)new ButtonBack(this.guiLeft + this.xSize / 6, this.guiTop, btn -> this.field_230706_i_.func_147108_a(this.parent), this));
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.currentPage <= this.searchResults.size() - 1) {
                ++this.currentPage;
            }
        }, this);
        this.func_230480_a_((Widget)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.currentPage > 0) {
                --this.currentPage;
            }
        }, this);
        this.func_230480_a_((Widget)this.buttonPrev);
        this.searchField = new TextFieldWidget(this.field_230712_o_, this.guiLeft + 43, this.guiTop + 12, 100, 10, (ITextComponent)new TranslationTextComponent("guideapi.button.search"));
        this.searchField.func_146185_a(false);
        this.searchField.func_231049_c__(true);
        this.searchResults = SearchScreen.getMatches(this.book, null, this.player, this.bookStack);
    }

    @Override
    public boolean func_231046_a_(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!this.searchField.func_230999_j_()) {
            return super.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_);
        }
        if (keyCode == 256) {
            this.searchField.func_231049_c__(false);
        }
        if (this.searchField.func_231046_a_(keyCode, p_keyPressed_2_, p_keyPressed_3_)) {
            this.updateSearch();
        }
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int typeofClick) {
        if (!super.func_231044_a_(mouseX, mouseY, typeofClick)) {
            if (typeofClick == 0) {
                int entryX = this.guiLeft + 37;
                int entryY = this.guiTop + 30;
                if (this.searchResults.size() != 0 && this.currentPage >= 0 && this.currentPage < this.searchResults.size()) {
                    List<Pair<EntryAbstract, CategoryAbstract>> pageResults = this.searchResults.get(this.currentPage);
                    for (Pair<EntryAbstract, CategoryAbstract> entry : pageResults) {
                        if (GuiHelper.isMouseBetween(mouseX, mouseY, entryX, entryY, 4 * this.xSize / 6, 10)) {
                            GuideMod.PROXY.openEntry(this.book, (CategoryAbstract)entry.getRight(), (EntryAbstract)entry.getLeft(), this.player, this.bookStack);
                        }
                        entryY += 13;
                    }
                }
            } else if (typeofClick == 1) {
                if (GuiHelper.isMouseBetween(mouseX, mouseY, this.searchField.field_230690_l_, this.searchField.field_230691_m_, this.searchField.func_146200_o(), this.searchField.func_238483_d_())) {
                    this.searchField.func_146180_a("");
                    this.lastQuery = "";
                    this.searchResults = SearchScreen.getMatches(this.book, "", this.player, this.bookStack);
                    return true;
                }
                this.field_230706_i_.func_147108_a(this.parent);
                return true;
            }
            return this.searchField.func_231044_a_(mouseX, mouseY, typeofClick);
        }
        return true;
    }

    private void updateSearch() {
        if (!this.searchField.func_146179_b().equalsIgnoreCase(this.lastQuery)) {
            this.lastQuery = this.searchField.func_146179_b();
            this.searchResults = SearchScreen.getMatches(this.book, this.searchField.func_146179_b(), this.player, this.bookStack);
            if (this.currentPage > this.searchResults.size()) {
                this.currentPage = this.searchResults.size() - 1;
            }
        }
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double movement) {
        if (movement < 0.0 && this.buttonNext.field_230694_p_ && this.currentPage <= this.searchResults.size()) {
            ++this.currentPage;
        } else if (movement > 0.0 && this.buttonPrev.field_230694_p_ && this.currentPage > 0) {
            --this.currentPage;
        }
        return movement != 0.0 || super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, movement);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.field_230706_i_.func_110434_K().func_110577_a(this.pageTexture);
        this.func_238474_b_(stack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.field_230706_i_.func_110434_K().func_110577_a(this.outlineTexture);
        this.drawTexturedModalRectWithColor(stack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.getColor());
        SearchScreen.func_238467_a_((MatrixStack)stack, (int)(this.searchField.field_230690_l_ - 1), (int)(this.searchField.field_230691_m_ - 1), (int)(this.searchField.field_230690_l_ + this.searchField.func_146200_o() + 1), (int)(this.searchField.field_230691_m_ + this.searchField.func_238483_d_() + 1), (int)new Color(166, 166, 166, 128).getRGB());
        SearchScreen.func_238467_a_((MatrixStack)stack, (int)this.searchField.field_230690_l_, (int)this.searchField.field_230691_m_, (int)(this.searchField.field_230690_l_ + this.searchField.func_146200_o()), (int)(this.searchField.field_230691_m_ + this.searchField.func_238483_d_()), (int)new Color(58, 58, 58, 128).getRGB());
        this.searchField.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        int entryX = this.guiLeft + 37;
        int entryY = this.guiTop + 30;
        if (this.searchResults.size() != 0 && this.currentPage >= 0 && this.currentPage < this.searchResults.size()) {
            List<Pair<EntryAbstract, CategoryAbstract>> pageResults = this.searchResults.get(this.currentPage);
            for (Pair<EntryAbstract, CategoryAbstract> entry : pageResults) {
                ((EntryAbstract)entry.getLeft()).draw(stack, this.book, (CategoryAbstract)entry.getRight(), entryX, entryY, 4 * this.xSize / 6, 10, mouseX, mouseY, this, this.field_230712_o_);
                ((EntryAbstract)entry.getLeft()).drawExtras(stack, this.book, (CategoryAbstract)entry.getRight(), entryX, entryY, 4 * this.xSize / 6, 10, mouseX, mouseY, this, this.field_230712_o_);
                if (GuiHelper.isMouseBetween(mouseX, mouseY, entryX, entryY, 4 * this.xSize / 6, 10) && GLFW.glfwGetKey((long)this.field_230706_i_.func_228018_at_().func_198092_i(), (int)340) == 1) {
                    GuiUtilsCopy.drawHoveringText(stack, ((CategoryAbstract)entry.getRight()).getTooltip(), mouseX, mouseY, this.field_230708_k_, this.field_230709_l_, 300, this.field_230712_o_);
                }
                entryY += 13;
            }
        }
        this.buttonPrev.field_230694_p_ = this.currentPage != 0;
        this.buttonNext.field_230694_p_ = this.currentPage != this.searchResults.size() - 1 && !this.searchResults.isEmpty();
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }
}

