/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.item;

import de.maxanier.guideapi.GuideMod;
import de.maxanier.guideapi.api.BookEvent;
import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.IGuideLinked;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ItemGuideBook
extends Item
implements IGuideItem {
    @Nonnull
    private final Book book;
    private String translation_key;

    public ItemGuideBook(Book book) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(book.getCreativeTab()));
        this.book = book;
        this.setTranslation_key("guideapi-vp.book." + book.getRegistryName().func_110624_b() + "." + book.getRegistryName().func_110623_a());
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        return this.book.getRegistryName().func_110624_b();
    }

    protected String func_195935_o() {
        if (this.translation_key == null) {
            this.translation_key = Util.func_200697_a((String)"item", (ResourceLocation)Registry.field_212630_s.func_177774_c((Object)this));
        }
        return this.translation_key;
    }

    protected void setTranslation_key(String name) {
        this.translation_key = Util.func_200697_a((String)"item", (ResourceLocation)new ResourceLocation("guideapi-vp", name));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (!world.func_201670_d()) {
            return ActionResult.func_226248_a_((Object)heldStack);
        }
        BookEvent.Open event = new BookEvent.Open(this.book, heldStack, player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            player.func_146105_b(event.getCanceledText(), true);
            return ActionResult.func_226251_d_((Object)heldStack);
        }
        GuideMod.PROXY.openGuidebook(player, world, this.book, heldStack);
        return ActionResult.func_226248_a_((Object)heldStack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195991_k().field_72995_K || !context.func_225518_g_()) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (state.func_177230_c() instanceof IGuideLinked) {
            IGuideLinked guideLinked = (IGuideLinked)state.func_177230_c();
            ResourceLocation entryKey = guideLinked.getLinkedEntry(context.func_195991_k(), context.func_195995_a(), context.func_195999_j(), stack);
            if (entryKey == null) {
                return ActionResultType.FAIL;
            }
            for (CategoryAbstract category : this.book.getCategoryList()) {
                if (!category.entries.containsKey(entryKey)) continue;
                GuideMod.PROXY.openEntry(this.book, category, category.entries.get(entryKey), context.func_195999_j(), stack);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public void func_77624_a(ItemStack stack, World playerIn, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (this.book.getAuthor() != null) {
            tooltip.add(this.book.getAuthor());
            if (advanced == ITooltipFlag.TooltipFlags.ADVANCED) {
                tooltip.add((ITextComponent)new StringTextComponent(this.book.getRegistryName().toString()));
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return this.getBook(stack).getItemName() != null ? this.getBook(stack).getItemName() : super.func_200295_i(stack);
    }

    @Override
    public Book getBook(ItemStack stack) {
        return this.book;
    }
}

