/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.network;

import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.util.NBTBookTags;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class PacketSyncCategory {
    public int category;
    public int page;

    public PacketSyncCategory() {
        this.category = -1;
        this.page = -1;
    }

    public PacketSyncCategory(int category, int page) {
        this.category = category;
        this.page = page;
    }

    static void encode(PacketSyncCategory msg, PacketBuffer buf) {
        buf.writeInt(msg.category);
        buf.writeInt(msg.page);
    }

    static PacketSyncCategory decode(PacketBuffer buf) {
        PacketSyncCategory msg = new PacketSyncCategory();
        msg.category = buf.readInt();
        msg.page = buf.readInt();
        return msg;
    }

    public static void handle(PacketSyncCategory msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            ItemStack book = player.func_184592_cb();
            if (book.func_190926_b() || !(book.func_77973_b() instanceof IGuideItem)) {
                book = player.func_184614_ca();
            }
            if (!book.func_190926_b() && book.func_77973_b() instanceof IGuideItem && msg.category != -1 && msg.page != -1) {
                if (!book.func_77942_o()) {
                    book.func_77982_d(new CompoundNBT());
                }
                book.func_77978_p().func_74768_a(NBTBookTags.CATEGORY_TAG, msg.category);
                book.func_77978_p().func_74768_a(NBTBookTags.ENTRY_PAGE_TAG, msg.page);
                book.func_77978_p().func_82580_o(NBTBookTags.ENTRY_TAG);
            }
        });
        ctx.setPacketHandled(true);
    }
}

