/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.network;

import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.util.NBTBookTags;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.lang3.Validate;

public class PacketSyncEntry {
    public int category;
    public ResourceLocation entry;
    public int page;

    public PacketSyncEntry() {
        this.category = -1;
        this.entry = new ResourceLocation("guideapi-vp", "none");
        this.page = -1;
    }

    public PacketSyncEntry(int category, ResourceLocation entry, int page) {
        this.category = category;
        this.entry = entry;
        this.page = page;
    }

    static void encode(PacketSyncEntry msg, PacketBuffer buf) {
        buf.writeInt(msg.category);
        buf.func_192572_a(msg.entry);
        buf.writeInt(msg.page);
    }

    static PacketSyncEntry decode(PacketBuffer buf) {
        PacketSyncEntry msg = new PacketSyncEntry();
        msg.category = buf.readInt();
        msg.entry = buf.func_192575_l();
        msg.page = buf.readInt();
        return msg;
    }

    public static void handle(PacketSyncEntry msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayerEntity player = ctx.getSender();
        Validate.notNull((Object)player);
        ctx.enqueueWork(() -> {
            ItemStack book = player.func_184592_cb();
            if (book.func_190926_b() || !(book.func_77973_b() instanceof IGuideItem)) {
                book = player.func_184614_ca();
            }
            if (!book.func_190926_b() && book.func_77973_b() instanceof IGuideItem && msg.category != -1 && !msg.entry.equals((Object)new ResourceLocation("guideapi-vp", "none")) && msg.page != -1) {
                if (!book.func_77942_o()) {
                    book.func_77982_d(new CompoundNBT());
                }
                book.func_77978_p().func_74768_a(NBTBookTags.CATEGORY_TAG, msg.category);
                book.func_77978_p().func_74778_a(NBTBookTags.ENTRY_TAG, msg.entry.toString());
                book.func_77978_p().func_74768_a(NBTBookTags.PAGE_TAG, msg.page);
            }
        });
        ctx.setPacketHandled(true);
    }
}

