/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.maxanier.guideapi.api.SubTexture;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.GuiHelper;
import de.maxanier.guideapi.api.util.IngredientCycler;
import de.maxanier.guideapi.api.util.TextHelper;
import de.maxanier.guideapi.gui.BaseScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.brewing.BrewingRecipe;

public class PageBrewingRecipe
extends Page {
    public BrewingRecipe recipe;
    public Ingredient ingredient;
    public Ingredient input;
    public ItemStack output;
    private final IngredientCycler cycler = new IngredientCycler();

    public PageBrewingRecipe(BrewingRecipe recipe) {
        this.recipe = recipe;
        this.ingredient = recipe.getIngredient();
        this.input = recipe.getInput();
        this.output = recipe.getOutput();
    }

    public PageBrewingRecipe(Ingredient input, Ingredient ingredient, ItemStack output) {
        this.input = input;
        this.output = output;
        this.ingredient = ingredient;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack stack, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, FontRenderer fontRendererObj) {
        this.cycler.tick(guiBase.getMinecraft());
        int xStart = guiLeft + 88;
        int yStart = guiTop + 52;
        SubTexture.POTION_GRID.draw(stack, xStart, yStart);
        ArrayList<ITextComponent> badTip = new ArrayList<ITextComponent>();
        badTip.add((ITextComponent)new TranslationTextComponent("guideapi.text.brewing.error"));
        guiBase.drawCenteredStringWithoutShadow(stack, fontRendererObj, TextHelper.localizeEffect("guideapi.text.brewing.brew", new Object[0]), guiLeft + guiBase.xSize / 2, guiTop + 12, 0);
        int x = xStart + 25;
        int y = yStart + 1;
        int finalX = x;
        int finalY = y;
        this.cycler.getCycledIngredientStack(this.ingredient, 0).ifPresent(s -> GuiHelper.drawItemStack(stack, s, finalX, finalY));
        List<ITextComponent> tooltip = null;
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.ingredient.func_193365_a()[0]);
        }
        GuiHelper.drawItemStack(stack, this.input.func_193365_a()[0], x, y += 39);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.input.func_193365_a()[0]);
        }
        int hSpacing = 24;
        GuiHelper.drawItemStack(stack, this.input.func_193365_a()[0], x -= hSpacing, y -= 8);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.input.func_193365_a()[0]);
        }
        GuiHelper.drawItemStack(stack, this.input.func_193365_a()[0], x += hSpacing * 2, y);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.input.func_193365_a()[0]);
        }
        if (this.output.func_190926_b()) {
            this.output = new ItemStack((IItemProvider)Blocks.field_180401_cv);
        }
        x = xStart + 25;
        GuiHelper.drawItemStack(stack, this.output, x, y += 31);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            List<ITextComponent> list = tooltip = this.output.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv) ? badTip : GuiHelper.getTooltip(this.output);
        }
        if (this.output.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv)) {
            guiBase.drawCenteredStringWithoutShadow(stack, fontRendererObj, TextHelper.localizeEffect("guideapi.text.brewing.error", new Object[0]), guiLeft + guiBase.xSize / 2, guiTop + 4 * guiBase.ySize / 6, 15533885);
        }
        if (tooltip != null) {
            guiBase.func_243308_b(stack, tooltip, mouseX, mouseY);
        }
    }
}

